const tagData = {
  "tag-gp__planning": {
    "groupId": "tag-gp__planning",
    "groupColor": "#7da7d9",
    "label": "企画・目的",
    "description": "動画の目的や用途に関する分類です。",
    "categories": {
      "tag__genre": {
        "label": "動画ジャンル",
        "prefix": "tag__genre",
        "description": "動画のジャンル・主な用途を分類（複数該当もOK）",
        "showSpecialTags": {
          "special_tag__none": true,
          "special_tag__not_applicable": true,
          "special_tag__other": true,
          "special_tag__note": true
        },
        "tags": [
          {
            "id": "tag__genre__service_promo",
            "label": "サービス紹介",
            "shortLabel": "",
            "description": "自社サービスやアプリの機能・メリット紹介"
          },
          {
            "id": "tag__genre__company_profile",
            "label": "会社紹介",
            "shortLabel": "",
            "description": "企業理念・雰囲気・事業内容の紹介"
          },
          {
            "id": "tag__genre__recruit",
            "label": "採用動画",
            "shortLabel": "",
            "description": "求人・職場の魅力・社員インタビュー"
          }
        ]
      },
      "tag__goal": {
        "label": "動画の目的",
        "prefix": "tag__goal",
        "description": "何のための動画か",
        "showSpecialTags": {
          "special_tag__none": true,
          "special_tag__not_applicable": true,
          "special_tag__other": true,
          "special_tag__note": true
        },
        "tags": [
          {
            "id": "tag__goal__purchase",
            "label": "購入促進",
            "shortLabel": "",
            "description": "商品購入や申込の促進"
          },
          {
            "id": "tag__goal__recognition",
            "label": "認知拡大",
            "shortLabel": "",
            "description": "名前・存在を知ってもらう"
          },
          {
            "id": "tag__goal__trust",
            "label": "信頼構築",
            "shortLabel": "",
            "description": "安心感・信頼性を高める"
          }
        ]
      },
      "tag__target": {
        "label": "ターゲット層",
        "prefix": "tag__target",
        "description": "主な想定視聴者層・ターゲットを分類",
        "showSpecialTags": {
          "special_tag__none": true,
          "special_tag__not_applicable": true,
          "special_tag__other": true,
          "special_tag__note": true
        },
        "tags": [
          {
            "id": "tag__target__general",
            "label": "一般向け",
            "shortLabel": "",
            "description": "制限なく幅広い層"
          },
          {
            "id": "tag__target__business",
            "label": "ビジネス層",
            "shortLabel": "",
            "description": "企業・ビジネス用途"
          },
          {
            "id": "tag__target__youth",
            "label": "若年層",
            "shortLabel": "",
            "description": "10〜20代が中心"
          },
          {
            "id": "tag__target__senior",
            "label": "シニア層",
            "shortLabel": "",
            "description": "高齢者・シニア向け"
          },
          {
            "id": "tag__target__kids",
            "label": "子ども向け",
            "shortLabel": "",
            "description": "小学生まで"
          },
          {
            "id": "tag__target__family",
            "label": "ファミリー",
            "shortLabel": "",
            "description": "家族・親子"
          },
          {
            "id": "tag__target__couple",
            "label": "カップル向け",
            "shortLabel": "",
            "description": "夫婦・カップル"
          }
        ]
      }
    }
  },
  "tag-gp__design": {
    "groupId": "tag-gp__design",
    "groupColor": "#d78dd0",
    "label": "デザイン",
    "description": "テイストや配色など、ビジュアルの雰囲気に関する分類です。",
    "categories": {
      "tag__taste": {
        "label": "テイスト",
        "prefix": "tag__taste",
        "description": "全体のデザインの雰囲気やテイスト、印象を表現する分類（複数選択も可）",
        "showSpecialTags": {
          "special_tag__none": true,
          "special_tag__not_applicable": true,
          "special_tag__other": true,
          "special_tag__note": true
        },
        "tags": [
          {
            "id": "tag__taste__simple",
            "label": "シンプル",
            "shortLabel": "",
            "description": "無駄を省いた、ミニマルで落ち着いた雰囲気"
          },
          {
            "id": "tag__taste__pop",
            "label": "ポップ",
            "shortLabel": "",
            "description": "明るく楽しい、カジュアルで親しみやすい印象"
          },
          {
            "id": "tag__taste__modern",
            "label": "スタイリッシュ",
            "shortLabel": "",
            "description": "先進的・洗練・今っぽいデザイン"
          }
        ]
      },
      "tag__telop": {
        "label": "テロップ",
        "prefix": "tag__telop",
        "description": "テロップの使用方法や演出スタイルを分類（フル・動的・補足）",
        "showSpecialTags": {
          "special_tag__none": true,
          "special_tag__not_applicable": true,
          "special_tag__other": true,
          "special_tag__note": true
        },
        "tags": [
          {
            "id": "tag__telop__no_telop",
            "label": "なし",
            "shortLabel": "",
            "description": "テロップなし"
          },
          {
            "id": "tag__telop__with_telop",
            "label": "あり",
            "shortLabel": "",
            "description": "テロップあり"
          }
        ]
      }
    }
  },
  "tag-gp__audio": {
    "groupId": "tag-gp__audio",
    "groupColor": "#9fa4dd",
    "label": "音声・BGM",
    "description": "ナレーションやBGM・効果音など、音に関する分類です。",
    "categories": {
      "tag__narration": {
        "label": "ナレーション",
        "prefix": "tag__narration",
        "description": "ナレーションの種類（性別・AI音声・なし）を分類",
        "showSpecialTags": {
          "special_tag__none": true,
          "special_tag__not_applicable": true,
          "special_tag__other": true,
          "special_tag__note": true
        },
        "tags": [
          {
            "id": "tag__narration__no_narration",
            "label": "なし",
            "shortLabel": "",
            "description": "ナレーションがない"
          },
          {
            "id": "tag__narration__with_narration",
            "label": "あり",
            "shortLabel": "",
            "description": "ナレーションがある"
          }
        ]
      },
      "tag__bgm": {
        "label": "BGM",
        "prefix": "tag__bgm",
        "description": "動画内で使われているBGMの有無や役割（ナビとして機能するかなど）を分類",
        "showSpecialTags": {
          "special_tag__none": true,
          "special_tag__not_applicable": true,
          "special_tag__other": true,
          "special_tag__note": true
        },
        "tags": [
          {
            "id": "tag__bgm__with_bgm",
            "label": "あり",
            "shortLabel": "",
            "description": "BGMがある"
          },
          {
            "id": "tag__bgm__no_bgm",
            "label": "なし",
            "shortLabel": "",
            "description": "BGMがない"
          }
        ]
      },
      "tag__se": {
        "label": "SE",
        "prefix": "tag__se",
        "description": "SE（効果音）の有無を分類（操作音や装飾音含む）",
        "showSpecialTags": {
          "special_tag__none": true,
          "special_tag__not_applicable": true,
          "special_tag__other": true,
          "special_tag__note": true
        },
        "tags": [
          {
            "id": "tag__se__with_se",
            "label": "あり",
            "shortLabel": "",
            "description": "効果音がある"
          },
          {
            "id": "tag__se__no_se",
            "label": "なし",
            "shortLabel": "",
            "description": "効果音がない"
          }
        ]
      }
    }
  }
};