/*
  © 2025 Avery.  
  このファイルは著作権者により配布され、再配布・販売は禁止されています。  
  詳細は usage_guide.html のライセンス欄をご確認ください。
*/

/* =========================================
 * TAGFLOT Usage Guide  ─  Language Utility
 * 専用の軽量翻訳ファイル（usage_guide.html 用）
 * ========================================= */

// ▼ 最低限の翻訳辞書（ガイドで使うキーだけ）
window.translations = {
  ja: {

    // ▼===使い方ガイド===▼

    // ▼ Tagflotツール一覧（テキストリンク）
    "guide_toollist_section_title": "Tagflot ツール一覧：",
    "guide_toolname_eagle_converter": "カテゴリ名・区切り変換ツール",

    //▼章見出し(h2)
    "guide_section_heading__basic_flow": "1. 基本の使い方",
    "guide_section_heading__features": "2. 各機能の解説",
    "guide_section_heading__advanced": "3. 発展的な使い方・カスタマイズ",
    "guide_section_heading__operation": "4. 運用・その他",

    //▼1-1.tagflotについて
    "guide_intro__1_1": "1-1.tagflotについて",
    "guide_intro__1_2": "tagflotとは",
    "guide_intro__1_3": "tagflot(タグフロット)は、<br><strong>Eagle専用の非公式タグ付与・管理ツール</strong>です。",
    "guide_intro__1_4": "素材へのタグ付けを<strong>簡単かつ大量に</strong>行えます。<br>タグの内容や使い方はユーザーごとに自由にカスタマイズできます。<br><strong>Eagleの検索・管理機能を最大限に活用できる設計になっています。</strong>",
    "guide_intro__1_5": "🧩 主な特徴",
    "guide_intro__1_6": "タグを <strong>グループ →カテゴリ → タグ</strong> の3階層で整理し、自分専用の分類体系を作成",
    "guide_intro__1_7": "複数タグの組み合わせを<strong>プリセット</strong>に登録することで、ワンクリックで大量のタグ選択ができます",
    "guide_intro__1_8": "出力形式やボタンはカスタマイズでき、タグ出力をコントロール",
    "guide_intro__1_9": "自分で作成したタグを、<strong>Eagleのスマートフォルダで自動分類</strong>に活用可能",
    "guide_intro__1_10": "<strong>サーバー不要・完全ローカル動作（保存は手動）</strong>",
    "guide_intro__1_11": "🧑‍💻 こんな方に最適",
    "guide_intro__1_12": "Eagleでタグを活用しきれていないと感じる",
    "guide_intro__1_13": "動画に対して「分類・整理・分析」を本気でやりたい",
    "guide_intro__1_14": "<strong>タグ付け＝情報付与・構造化作業</strong>として活用したい",
    "guide_intro__1_15": "静止画ではなく「動画」にこそタグで意味づけしたい",

    //▼1-2.初めての方へ｜基本ステップ
    "guide_basicsteps__1_1": "1-2.初めての方へ｜基本ステップ",
    "guide_basicsteps__1_2": "基本ステップ",
    "guide_basicsteps__1_3": "✨ Step 1｜タグを作成する",
    "guide_basicsteps__1_4": "タグ編集ツールで自分の用途や分類に合ったグループ・カテゴリ・タグを作成します。",
    "guide_basicsteps__1_5": "⚙️ Step 2｜タグを選んで出力する",
    "guide_basicsteps__1_6": "必要なタグを選び、クリップボードにコピーします。",
    "guide_basicsteps__1_7": "🏷️ Step 3｜Eagleでタグ付け",
    "guide_basicsteps__1_8": "Eagleでタグ付けしたいアイテムを選択し、「新しいタグ」の検索欄にタグをペーストするとアイテムにタグが付きます。",
    "guide_basicsteps__1_9": "さらに便利に使うには｜プリセット機能",
    "guide_basicsteps__1_10": "「プリセット編集ツール」で、よく使うタグの組み合わせをプリセットに登録",
    "guide_basicsteps__1_11": "「メインツール」で、登録済みプリセットをクリックするだけで複数タグを一括選択",

    //▼1-3.保存について
    "guide_save__1_1": "1-3.保存・削除・バックアップ・新規作成について｜必ずお読みください",
    "guide_save__1_2": "保存について",
    "guide_save__1_3": "📍自動保存はありません",
    "guide_save__1_4": "このツールはHTMLとJavaScriptだけで動作するローカルツールです。<br>編集内容が自動で保存される機能はありません。",
    "guide_save__1_5": "💾保存方法",
    "guide_save__1_6": "編集ツール下部の「出力」ボタンを押し、<br><code>tags.js</code>や<code>presets.js</code>として保存してください。<br>ダウンロードしたファイルは<code>/data/</code>フォルダに上書き保存してください。<br>「出力」→「dataフォルダ内の同名ファイルに上書き保存」の2ステップが必要です。<br><strong>tags.jsやpresets.jsなどのデータを編集・上書きした後は、ページをリロード（再読み込み）するとツールにすぐ反映されます。</strong><br>  反映されない場合はブラウザのキャッシュをクリアして再度読み込んでください。",
    "guide_save__1_7": "📝ファイル名について",
    "guide_save__1_8": "ツールが自動で読み込むのは「data/tags.js」「data/presets.js」「data/special_tags.js」など、決まったファイル名のみです。<br>ダウンロードやコピーを繰り返すと「tags (1).js」や「tags(2).js」などが自動生成される場合がありますが、それらはツールで認識されません。<br>新しいデータを利用する際は、使用したいファイルの名前を必ず<code>tags.js</code>、<code>presets.js</code>、<code>special_tags.js</code>、<code>button_toggle_category.js</code>に変更してください。",
    "guide_save__1_9": "おすすめの使い方",
    "guide_save__1_10": "編集が多い場合などは、作業の合間にこまめに「出力」ボタンで保存しておくのがおすすめです。<br>最終版を<code>tags.js</code>や<code>presets.js</code>に名前を整えて<code>data</code>フォルダに配置することで、メインツールにすぐ反映できます。",
    "guide_save__1_19": "制作者の実践例",
    "guide_save__1_20": "私は <code>tags.js</code> や <code>presets.js</code> をテキストエディタで常に開いておき、タグやプリセット編集後に出力したコードをコピーして丸ごと上書き保存→ツールをリロードして即座に反映、というサイクルで編集と確認を繰り返しています。<br>",
    "guide_save__1_11": "新規作成について",
    "guide_save__1_12": "✨新規作成の方法",
    "guide_save__1_13": "はじめからタグやプリセットを作り直したい場合は、<code>tags.js</code>や<code>presets.js</code>を<code>data</code>フォルダから削除し、各編集ツールを起動してください。<br>ファイルが存在しない場合は「新規作成ダイアログ」が表示され、空のデータから新しく作り直すことができます。<br>新規作成やダウンロードを行っても、既存ファイルが自動で上書き・削除されることはありません。<br>データの整理やリセットにも安心してご利用いただけます。<br>新規作成についての詳細な手順は、タグ編集ツール・プリセット編集ツールそれぞれの使い方セクションもご参照ください。",
    "guide_save__1_14": "バックアップについて",
    "guide_save__1_15": "💿バックアップ方法",
    "guide_save__1_16": "タグやプリセットなど、全てのデータは<code>data</code>フォルダ内にあります。<br>万一に備えて、<code>data</code>フォルダごとコピーしておけば、簡単にバックアップが完了します。<br>ファイル単位でバックアップする場合は、<code>tags_backup.js</code>などの別名で同じフォルダ内に保存しても問題ありません。<br>バックアップファイルや過去のデータは、手動で削除しない限りそのまま残るため、必要に応じて復元や管理ができます。",
    "guide_save__1_17": "削除方法",
    "guide_save__1_18": "このツールを削除したい場合は、フォルダごと削除するだけで完了します。<br>レジストリやシステム設定への書き込み等は一切ありません。",

    //▼1-4.各ページの役割と使い分け
    "guide_roles__1_1": "1-4.各ツールの役割と使い分け",
    "guide_roles__1_2": "各ツールについて",
    "guide_roles__1_3": "🛠️ タグ編集ツール（tag_editor.html）",
    "guide_roles__1_4": "タグの「追加・整理・編集」を行う専用ツールです。<br>ご自身でタグを作成しないと、メインツールにタグが表示されません。<br>（※初回はデモ用のタグがいくつか登録されています）",
    "guide_roles__1_5": "🧩 プリセット編集ツール（preset_editor.html）",
    "guide_roles__1_6": "複数のタグを“ひとまとめ”にして、ワンクリックで一度に付与できるプリセットを作成できます。<br>タグ付け作業の時短や、よく使うセットを手軽に再利用したい人におすすめです。",
    "guide_roles__1_7": "🏷️ メインツール（tagflot.html）",
    "guide_roles__1_8": "登録済みのタグやプリセットを使用して、実際にタグの選択と出力をするツールです。<br>",
    "guide_roles__1_9": "🧰 TSV/JS変換ツール（tool_convert_tsv_to_js.html）",
    "guide_roles__1_10": "タグやプリセット定義の表形式（TSV）⇔JavaScriptデータ（tags.js/presets.js）間の変換を行う補助ツールです。<br>Excelやテキストエディタで編集した内容を簡単にツールに取り込んだり、出力結果を管理できます。",

    //▼2-1.タグ編集ツールの使い方
    "guide_tag_editor__1_1": "2-1.タグ編集ツールの使い方（tag_editor.html）",
    "guide_tag_editor__1_2": "基本の使い方（タグを作成する手順）",
    "guide_tag_editor__1_3": "タグの作成と編集",
    "guide_tag_editor__1_4": "グループ - カテゴリ - タグの三階層で管理します。<br>",
    "guide_tag_editor__1_5": "保存と反映",
    "guide_tag_editor__1_6": "完成したタグを tags.js として保存し<code>/data/tags.js</code>に上書きします。",
    "guide_tag_editor__1_23": "新規作成について",
    "guide_tag_editor__1_24": "既存のタグデータ（<code>tags.js</code>）を削除して編集ツールを開くと、空の状態からグループ・カテゴリ・タグを自由に登録できます。<br>データファイルが<code>data</code>フォルダに存在しない場合も自動的に新規作成が案内されます。<br>編集や整理の際に一度すべてリセットしたい場合にも利用できます。<br>元のファイルを残したい場合は、別名（例：<code>tags_backup.js</code>）に変更するか別フォルダで保管してください。",
    "guide_tag_editor__1_7": "注意｜保存について",
    "guide_tag_editor__1_8": "※<code>/data/tags.js</code>に上書きや差し替えをしない限りメインツールには反映されません。",
    "guide_tag_editor__1_9": "各機能のポイント",
    "guide_tag_editor__1_10": "ショートラベルの使用",
    "guide_tag_editor__1_11": "ショートラベルはボタン表示用の短縮名で、表示が崩れる場合などに使用します（出力には影響しません）。<br>通常は設定不要です。",
    "guide_tag_editor__1_12": "グループカラーの反映",
    "guide_tag_editor__1_13": "グループカラーは、メインツールの「カテゴリ左帯」や「説明テーブル」に反映されます。",
    "guide_tag_editor__1_14": "特殊タグについて",
    "guide_tag_editor__1_15": "特殊タグの表示設定",
    "guide_tag_editor__1_16": "「未選択」「該当なし」「その他」など、各カテゴリに共通する特殊タグの表示／非表示を切り替えられます。",
    "guide_tag_editor__1_17": "未選択の仕様",
    "guide_tag_editor__1_18": "「未選択」は常に表示され、カテゴリ毎のタグ選択のリセットボタンとしても機能します。<br>出力に含めるか設定できます。",
    "guide_tag_editor__1_19": "特殊タグの追加",
    "guide_tag_editor__1_20": "特殊タグは複数カテゴリに共通して表示したいタグがある場合、カスタム特殊タグとして追加できます。<br>追加方法についてはセクション3で詳しく説明しています。",
    "guide_tag_editor__1_21": "特殊タグのラベル・内容の変更",
    "guide_tag_editor__1_22": "既存の特殊タグやカスタム特殊タグの表示名や説明文を変更したい場合は、設定ファイルを編集してください。<br>編集手順はセクション3で解説しています。",


    //▼2-2.プリセット編集ツールの使い方
    "guide_preset_editor__1_1": "2-2.プリセット編集ツールの使い方（preset_editor.html）",
    "guide_preset_editor__1_2": "基本の使い方（プリセットの登録手順）",
    "guide_preset_editor__1_3": "グループとカテゴリの作成・編集",
    "guide_preset_editor__1_4": "プリセット用のグループとカテゴリを作成します。",
    "guide_preset_editor__1_5": "プリセットの作成・編集",
    "guide_preset_editor__1_6": "登録済みタグから必要なタグを選択しプリセットを作ります。<br>後からプリセットに含むタグの追加や削除も可能です。",
    "guide_preset_editor__1_7": "順序整理・編集",
    "guide_preset_editor__1_8": "プリセットの順序を整理し、必要に応じて削除や移動を行います。",
    "guide_preset_editor__1_9": "未定義タグの検知・削除",
    "guide_preset_editor__1_10": "プリセットに登録されているタグのIDが変更されたり削除された場合、「未定義タグ」を含むプリセット・カテゴリ・グループに通知が表示されます。<br>未定義タグを含むプリセットを自動で開くボタンもあります。<br>未定義タグは削除してください。<br>未定義タグはリンク切れのIDが表示されるので、それを参考にその場でタグの追加も出来ます。",
    "guide_preset_editor__1_11": "保存処理",
    "guide_preset_editor__1_12": "完成したデータを<code>presets.js</code>として保存します。<br><code>/data/presets.js</code> に上書き保存してください。",
    "guide_preset_editor__1_22": "新規作成について",
    "guide_preset_editor__1_23": "既存のプリセットデータ（<code>presets.js</code>）を削除してプリセット編集ツールを開くと、空の状態からグループ・カテゴリ・プリセットを自由に登録できます。<br>データファイルが<code>data</code>フォルダに存在しない場合も自動的に新規作成が案内されます。<br>編集や整理の際に一度すべてリセットしたい場合にも利用できます。<br>元のファイルを残したい場合は、別名（例：<code>presets_backup.js</code>）に変更するか別フォルダで保管してください。",
    "guide_preset_editor__1_13": "注意｜保存について",
    "guide_preset_editor__1_14": "※ <code>/data/presets.js</code>に上書きや差し替えをしない限りメインツールには反映されません。",
    "guide_preset_editor__1_15": "各機能のポイント",
    "guide_preset_editor__1_16": "ショートラベルの仕様",
    "guide_preset_editor__1_17": "ショートラベルはプリセット名が長い場合に使用され、ボタン表示にのみ反映されます。",
    "guide_preset_editor__1_18": "グループカラーの反映",
    "guide_preset_editor__1_19": "グループカラーは、メインツールの「説明テーブル」に反映されます。",
    "guide_preset_editor__1_20": "お気に入りフラグの反映",
    "guide_preset_editor__1_21": "お気に入りフラグ（★）を付けると、メインツール上でプリセットの右上に★マークが表示されます。",

    //▼2-3.メインツールの使い方（tagflot.html）
    "tagflot_feature_usage__1_1": "2-3.メインツールの使い方（tagflot.html）",
    "tagflot_feature_usage__1_2": "基本の使い方",
    "tagflot_feature_usage__1_3": "タグの選択",
    "tagflot_feature_usage__1_4": "タグやプリセットのボタンをクリックしてタグを選択します。",
    "tagflot_feature_usage__1_5": "出力の設定",
    "tagflot_feature_usage__1_6": "右下の出力設定コーナーで、形式・範囲などを設定します。",
    "tagflot_feature_usage__1_7": "タグのコピー",
    "tagflot_feature_usage__1_8": "コピーボタンを押すと、選択中のタグがクリップボードにコピーされます。<br>タグ選択テーブル下のテキストエリアにペーストして内容を確認できます。<br>ペーストした内容はすぐ下のリセットボタンで消すことができます。",
    "tagflot_feature_usage__1_9": "Eagleでタグを適用",
    "tagflot_feature_usage__1_10": "Eagleの「新しいタグ」欄に貼り付けて、タグを適用します。",
    "tagflot_feature_usage__1_11": "各機能のポイント",
    "tagflot_feature_usage__1_12": "📦プリセットについて",
    "tagflot_feature_usage__1_13": "プリセットの選択",
    "tagflot_feature_usage__1_14": "プリセットボタンを押すと、含まれるタグが現在の選択に追加されます。<br>※すでに選択されているタグは重複せずに保持されます。",
    "tagflot_feature_usage__1_15": "プリセットカラムの開閉",
    "tagflot_feature_usage__1_16": "画面右端上方のボタンで、プリセットエリアの表示／非表示を切り替えられます。",
    "tagflot_feature_usage__1_17": "グループ・カテゴリの一括開閉",
    "tagflot_feature_usage__1_18": "OPEN／CLOSE ボタンで、すべてのグループ・カテゴリをまとめて開閉できます。",
    "tagflot_feature_usage__1_19": "お気に入りプリセットの★表示",
    "tagflot_feature_usage__1_20": "お気に入りフラグが付いているプリセットには、ボタン右上に★マークが表示されます。<br>お気に入り登録はプリセット編集ツールでできます。",
    "tagflot_feature_usage__1_21": "プリセットの内容表示",
    "tagflot_feature_usage__1_22": "プリセットにマウスを乗せると、中央にそのプリセットに含まれるタグの一覧が画面中央にポップアップ表示されます。",
    "tagflot_feature_usage__1_23": "⚙️出力の切り替え",
    "tagflot_feature_usage__1_24": "出力・動作設定",
    "tagflot_feature_usage__1_25": "以下の3種類から出力形式を選択できます。<br>・カテゴリラベル：タグラベル<br>・カテゴリID：タグラベル<br>・タグラベルのみ<br>※ショートラベルが設定されている場合もタグのラベルが出力されます。",
    "tagflot_feature_usage__1_26": "出力対象の切り替え",
    "tagflot_feature_usage__1_27": "出力対象を「開いているカテゴリのみ」または「全カテゴリ」から選べます。<br>また、「未選択タグを含める／含めない」を選べます。",
    "tagflot_feature_usage__1_28": "説明の吹き出し表示",
    "tagflot_feature_usage__1_29": "マウスオンで、タグやカテゴリに設定した説明文が吹き出しで表示されます。<br>この吹き出し表示は、設定からオン／オフを切り替えられます。",
    "tagflot_feature_usage__1_30": "クリック音の設定",
    "tagflot_feature_usage__1_31": "ボタンをクリックしたときの効果音も、オン／オフを切り替えられます。<br>この設定もブラウザに自動で保存されます。",
    "tagflot_feature_usage__1_32": "出力設定の保存",
    "tagflot_feature_usage__1_33": "出力形式や出力範囲、説明の吹き出し表示・クリック音のオン／オフ設定はブラウザに自動で保存されます。<br>設定のリセットボタンもあります。",
    "tagflot_feature_usage__1_34": "📖 ボタン一覧について",
    "tagflot_feature_usage__1_35": "ボタン一覧カラムの開閉",
    "tagflot_feature_usage__1_36": "画面左端上方にあるボタンで、ボタン一覧カラムの表示／非表示を切り替えられます。",
    "tagflot_feature_usage__1_37": "ボタン一覧",
    "tagflot_feature_usage__1_38": "各ボタンのラベルと内容が表形式で表示されます。",
    "tagflot_feature_usage__1_39": "グループ・カテゴリの一括開閉",
    "tagflot_feature_usage__1_40": "OPEN／CLOSE ボタンで、すべてのグループ・カテゴリをまとめて開閉できます。",
    "tagflot_feature_usage__1_41": "🏷️タグ選択について",
    "tagflot_feature_usage__1_42": "タグ選択の表示",
    "tagflot_feature_usage__1_43": "選択されたタグは、画面下部に表示されます。クリックで該当カテゴリにジャンプできます。<br>表示されたタグに触れると右上に表示される × ボタンで、個別に選択を解除できます。",
    "tagflot_feature_usage__1_44": "未選択ボタンについて",
    "tagflot_feature_usage__1_45": "初期状態では各カテゴリの「未選択」ボタンが選択されています。<br>カテゴリ内のタグを選択後に「未選択」ボタンをクリックすると、カテゴリ内のすべての選択が解除されます。",
    "tagflot_feature_usage__1_46": "📝コード生成コーナーについて",
    "tagflot_feature_usage__1_47": "タグ選択テーブルの下にある「＋」ボタンを押すと、コード生成コーナーが開きます。<br>ここではデータの直接編集のためのコードの発行やデータ一覧の出力などが行えます。<br>詳しい使い方や注意事項はセクション3で解説しています。",

    //▼2-4.TSV/JS変換ツールの使い方
    "converter_feature_usage__1_1": "2-4.TSV/JS変換ツールの使い方（tool_convert_tsv_to_js.html）",
    "converter_feature_usage__1_2": "基本の使い方",
    "converter_feature_usage__1_3": "概要",
    "converter_feature_usage__1_4": "このツールは、タブ区切り形式（TSV）のタグ・プリセット定義データを、ツール内部で使用される tags.js および presets.js の形式に変換するための補助ツールです。Excel や Google スプレッドシートで管理しているデータを一括で反映したい場合に便利です。",
    "converter_feature_usage__1_5": "主な用途",
    "converter_feature_usage__1_6": "・大量のタグやプリセットをまとめて作成したい場合・複数人で共有・編集したスプレッドシートを取り込む場合・似た構成のプリセットを一括生成したい場合",
    "converter_feature_usage__1_7": "基本的な使い方",
    "converter_feature_usage__1_8": "1. メインツールからタグ／プリセットのデータをTSV形式で出力し、Excelやスプレッドシートに貼り付けて編集します。※ またはCSVとしてダウンロードし、テキストエディタ等で編集しても構いません。2. 編集後のデータは、次のいずれかの方法で読み込みます。・CSVファイルを読み込む・スプレッドシート上のセルをコピーして、ツールの入力欄にペーストする3. 該当する「変換」ボタンを押すと、整形済みの出力コードが表示されます。内容を確認し、tags.js または presets.js に上書き保存してください。",
    "converter_feature_usage__1_9": "入力と出力の仕様",
    "converter_feature_usage__1_10": "入力に関する注意事項",
    "converter_feature_usage__1_11": "・ラベルとIDは必須入力です。・IDの接頭語は以下のように指定してください： └ プリセットグループ: preset-gp__ └ タググループ: tagu-gp__ └ プリセットカテゴリ: preset__ └ タグカテゴリ: tag__ └ プリセット／タグ: 所属カテゴリID + __ ・IDに使用できる文字は半角英数字とアンダースコア（_）のみであり、また以下は禁止です。 └ アンダースコアが連続（例: a__b） └ アンダースコアが先頭または末尾にある（例: _abc, abc_）",
    "converter_feature_usage__1_12": "エラー通知",
    "converter_feature_usage__1_13": "・入力エラーがある場合は通知欄に警告が表示されます。・入力エラーがある場合は出力はされません。",
    "converter_feature_usage__1_14": "出力データの扱い",
    "converter_feature_usage__1_15": "・整形された出力コードは、そのまま tags.js や presets.js に貼り付けて使用できます。・出力結果はクリップボードにコピーするか、保存ボタンでダウンロードできます。",
    "converter_feature_usage__1_16": "ワンポイント",
    "converter_feature_usage__1_17": "・TSV形式は内部IDを含む構造で出力されるため、接頭語付きのIDが必要です。・編集ツールでは接頭語を除いたIDで入力・編集できます。・グループ・カテゴリの追加やカテゴリ間移動など、構造の整理には編集ツールの使用がおすすめです。",

    //▼2-5.アップデート通知機能について
    "guide_update_notify__1_1": "2-5.アップデート通知機能について",
    "guide_update_notify__1_2": "アップデート通知機能について",
    "guide_update_notify__1_3": "メインツール右下の<strong>アップデート通知ボタン</strong>から、最新情報やお知らせをいつでも確認できます。<br>（インターネット接続が必要です／外部にデータを送信することはありません）",
    "guide_update_notify__1_4": "🔃アップデート時のデータ引き継ぎ方法",
    "guide_update_notify__1_5": "新しいバージョンのtagflotを導入する際は、<code>data</code>フォルダ内のファイル（tags.js・presets.jsなど）を新しいバージョンの<code>data</code>フォルダに上書きコピーするだけで、これまでのデータを引き継げます。<br>※今後データ形式が変更される場合も、専用の変換ツールを配布予定です。",

    //▼3-1.コード生成の使い方
    "guide_section_codegen__1_1": "3-1.コード生成の使い方",
    "guide_section_codegen__1_2": "コード生成機能の使い方",
    "guide_section_codegen__1_3": "<strong>コード生成コーナー</strong>では、タグやプリセット／グループ／カテゴリなど各種コードの発行や、<strong>現在使われているタグ・プリセットの一覧出力（タブ区切り・CSV形式）</strong>が行えます。<br>※プリセットやタグの追加・編集はGUIで完結しますが、各種コードの手動生成やデータ出力も必要に応じて利用できます。<br><strong>カテゴリ開閉ボタン作成機能</strong>の使い方については専用セクションで説明しています。",
    "guide_section_codegen__1_4": "📤 データ一覧の出力手順",
    "guide_section_codegen__1_5": "1. 本体ツールから、現在使用中のタグ／プリセット一覧を出力",
    "guide_section_codegen__1_6": "2. 出力内容をすべてコピーし、エクセル等に貼り付けるかCSV保存して編集",
    "guide_section_codegen__1_7": "3. <strong>変換ツール</strong>に貼り付けて変換",
    "guide_section_codegen__1_8": "4.生成された<code>tags.js</code>や<code>presets.js</code>を<strong>dataフォルダに上書き</strong>、または内容を既存ファイルに貼り付けて保存",
    "guide_section_codegen__1_9": "⚠️注意点",
    "guide_section_codegen__1_10": "この出力は<strong>「現在使用中のデータの一覧」を書き出す補助機能</strong>です",
    "guide_section_codegen__1_11": "タグ名や構成を変更しても自動では反映されません。変更後は再出力→再変換が必要です",

    //▼3-2カテゴリ操作ボタンの使い方・追加方法
    "guide_section_category_toggle__1_1": "3-2カテゴリ操作ボタンの使い方・追加方法",
    "guide_section_category_toggle__1_2": "カテゴリ操作ボタンの使い方",
    "guide_section_category_toggle__1_3": "🗂️カテゴリ操作ボタンとは",
    "guide_section_category_toggle__1_4": "「カテゴリ操作ボタン」は、複数のカテゴリを一つのボタン操作でまとめて開閉したり、並び替えることができる機能です。<br>「標準ボタン」と「カスタムカテゴリ開閉ボタン」があります。",
    "guide_section_category_toggle__1_5": "🔘各標準ボタンの仕様",
    "guide_section_category_toggle__1_6": "※ボタン名や説明は、言語設定等によって多少異なる場合があります",
    "guide_section_category_toggle__1_7": "カスタムカテゴリ開閉ボタン",
    "guide_section_category_toggle__1_8": "⭐カスタムカテゴリ開閉ボタンとは",
    "guide_section_category_toggle__1_9": "「カスタムカテゴリ開閉ボタン」は、<strong>複数のカテゴリを一つのボタン操作でまとめて開閉できる</strong>機能です。<br>よく使う複数のカテゴリがある場合や、使用場面によって特定のカテゴリだけを使用する場合に便利です。",
    "guide_section_category_toggle__1_10": "🛠️作り方",
    "guide_section_category_toggle__1_11": "1. 開きたいカテゴリだけを「開いた状態」にする<br>2. メインツールのコード生成コーナーのフォームに「名前」と「ID（例：open_char）」を入力<br>3. 「カテゴリ開閉ボタン生成」を押すとコードが出力されます<br>4. button_toggle_category.js にコードをペーストして保存で登録完了です",
    "guide_section_category_toggle__1_12": "⚠️注意点",
    "guide_section_category_toggle__1_13": "IDには自動で接頭語が付きます。<br>変更しないでください。<br>（例：tagCategoryToggle__open_char）<br>以下は1ボタン分の定義例です。",
    "guide_section_category_toggle__1_14": "🔢 カスタムグループ構造例",
    "guide_section_category_toggle__1_15": "※ グループ間はカンマ <code>,</code> で区切り、自由に追加や並べ替えができます。<br>※ 標準グループ（openAll、closeAllなど）は不要な場合は削除可能です。",

    //▼3-3.特殊タグの使い方・追加方法
    "guide_section_special_tags__1_1": "3-3.特殊タグの使い方・追加方法",
    "guide_section_special_tags__1_2": "特殊タグについて",
    "guide_section_special_tags__1_3": "🔖特殊タグとは",
    "guide_section_special_tags__1_4": "特殊タグはカテゴリ共通で利用できるタグです。<br><strong>標準特殊タグ</strong>（「未選択」「該当なし」「その他」）は全カテゴリ共通で利用でき、<br>表示／非表示の切り替えはできますが、<strong>名前・説明・IDの変更はできません</strong>。<br>未選択タグは非表示にできません。",
    "guide_section_special_tags__1_5": "カスタム特殊タグ",
    "guide_section_special_tags__1_6": "⭐ カスタム特殊タグとは",
    "guide_section_special_tags__1_7": "複数のカテゴリに表示する特殊タグを自分で作ることができます。<br>カテゴリ毎の表示／非表示は標準特殊タグと同様にタグ編集ツールで切り替えられます。",
    "guide_section_special_tags__1_8": "🛠️カスタム特殊タグの追加方法",
    "guide_section_special_tags__1_9-1": "/data/special_tag_settings.js内の標準タグをコピーして使用してください。",
    "guide_section_special_tags__1_9-2": "<strong>idSuffix</strong>はIDとして使用し半角英数字と_を使用します。<code>special_tag__A</code>の形式で作ります。A部分は最初と末尾に_は使用不可、連続_(__)は使用不可です。他の特殊タグと重複しないようにしてください。",
    "guide_section_special_tags__1_9-3": "<strong>defaultLabel</strong>特殊タグの名前を入力（必須）、<strong>description</strong>は説明やメモ（任意）を入力します。",
    "guide_section_special_tags__1_10": "サンプル（カスタムタグ1件）：",
    "guide_section_special_tags__1_11": "🔢特殊タグ設定ファイル（special_tag_settings.js）の全体例",
    "guide_section_special_tags__1_12": "※ 標準タグ3種（未選択・該当なし・その他）は変更不可。<br>カスタム特殊タグはこの形式で追記してください。<br> 追加する場合は,に注意してください。",

    //▼3-4.効果的な使い方・活用術
    "guide_section_tips__1_1": "3-4.効果的な使い方・活用術",
    "guide_section_tips__1_2": "効果的な使い方・活用術",
    "guide_section_tips__1_3": "🗂️タイプ別のカテゴリ一括開閉",
    "guide_section_tips__1_4": "動画タイプごとに、必要なカテゴリを「カスタム開閉ボタン」で登録しておきます。<br>出力時は「開いているカテゴリのみ」を選択することで、目的のタイプ別に必要なタグだけを効率よく管理できます。",
    "guide_section_tips__1_5": "➖未選択タグの活用",
    "guide_section_tips__1_6": "「未選択タグ」も出力に含めておくことで、<br>・そのタグを\“意図的に付けなかった\”のか<br>・\“まだ判断していない\”だけなのか<br>の区別が明確になり、データの信頼性が向上します。",
    "guide_section_tips__1_7": "📦プリセットによる大量選択",
    "guide_section_tips__1_8": "プリセット機能を活用すれば、よく使うタグのセットをワンクリックで一括選択でき、<br>動画ごとの詳細な記録や、分類作業が圧倒的に効率化します。",
    "guide_section_tips__1_9": "💡Eagleのスマートフォルダ活用",
    "guide_section_tips__1_10": "タグやプリセットによる分類データはEagleのスマートフォルダと組み合わせて使うことで、<br>必要な素材や動画をすぐに絞り込めるようになります。",

    //▼3-5.効果的な使い方・活用術
    "guide_section_faq__1_1": "3-5.補足・素材について",
    "guide_section_faq__1_2": "アイコンについて",
    "guide_section_faq__1_3": "配布パッケージにはアイコン画像（Windows用ICO、Mac用ICNS）を<code>docs/image/</code>フォルダに同梱しています。<br>本ツールのアイコンを使用したい場合はこちらの画像をご利用ください。",



    //▼3-6.Eagle側のカテゴリ名・区切りの変換について

    "guide_related_tools__1_1": "3-6.Eagle側のカテゴリ名・区切りの変換について",
    "guide_related_tools__1_2": "Eagle Tag Converter",
    "guide_related_tools__1_3": "概要",
    "guide_related_tools__1_4": "tagflot の出力形式（カテゴリ名なし / ： / _ / __ など）に合わせて、<br>Eagle 内の既存タグを一括変換できるデスクトップアプリです。",
    "guide_related_tools__1_5": "主な機能",
    "guide_related_tools__1_6": "・カテゴリ名との区切り文字の一括変換<br>・カテゴリ名の一括変換<br><strong>バックアップ／復元機能付きで、通常の利用では安全に変換できます。</strong><br>※本ツールは非公式ツールです。ご利用は自己責任でお願いいたします。",
    "guide_related_tools__1_7": "詳細・ダウンロード",
    "guide_related_tools__1_8": "詳しい説明と最新版のダウンロードは tagflot の配布ページをご覧ください。<br>▶︎ <a href=\"https://flotidot.com/tools/tagflot/index.html\" target=\"_blank\">Eagle Tag Converter（tagflot 配布ページ）</a>",

    //▼4-1.このツールを作った理由
    "guide_section_motivation__1_1": "4-1.このツールを作った理由",
    "guide_section_motivation__1_2": "このツールを作った理由",
    "guide_section_motivation__1_3": "「リファレンスを整理したいけど、分類もタグ付けも苦手で手が止まってしまう」<br>そんな自分自身の悩みから、このツールは生まれました。",
    "guide_section_motivation__1_4": "参考動画を集めても、あとから見返すと分類されていない。<br>せっかくのストックが活かせないのは「仕組みのせい」だと気づいて、<br>もっと自分にとって直感的に使えるツールを作ってみようと思いました。",
    "guide_section_motivation__1_5": "UIや表示の順番、出力の形など、すべてを「使うときの動き方」に合わせて設計しています。<br>個人用ではありますが、誰かの整理にも役立てばうれしいです。",
    "guide_section_motivation__1_5b": "実はほとんど趣味と遊び心の延長で機能を盛り込みすぎました。<br>ここまで本格的なものにする必要はなかったのになんということでしょう。<br>せっかくなのでどなたかどうかお役立てください。",
    "guide_section_motivation__1_6": "最後に、Eagleという素晴らしいツールを届けてくださった開発者の皆さんに、心から感謝いたします。",
    "guide_section_motivation__1_7": "2025年7月15日<br><strong>Avery</strong>",

    //▼4-2.多言語対応について
    "guide_section_language__1_1": "4-2.多言語対応について",
    "guide_section_language__1_2": "多言語対応について",
    "guide_section_language__1_3": "画面右上の言語切替セレクタから、日本語・英語・中国語（繁体字）に切り替えられます。<br>翻訳はAIと手作業を併用しており、表記や品質の違いについてはご容赦ください。<br>Eagleが台湾発ソフトという理由から中国語（繁体字）にも対応しています。<br>なお、その他の言語も今後気まぐれで追加・削除されることがあります。",
    "guide_section_language__1_4": "⚠️言語切替についてのご注意",
    "guide_section_language__1_5": "プルダウンで言語を切り替えても一部の表示がすぐに反映されない場合は、<br>ページをリロード（再読み込み）すると正しく表示されます。",

    //▼4-3.バージョン情報
    "guide_section_version": "4-3.バージョン情報",
    "guide_version_note": "※本セクションは日本語のみです",

    //▼4-4.ライセンス・利用条件・コンタクト
    "guide_section_license__1_1": "4-4.ライセンス・利用条件・コンタクト",
    "guide_section_license__1_2": "ライセンス・利用条件・コンタクト",
    "guide_section_license__1_3": "このツールおよびガイドの著作権は開発者（Avery）が保有します。",
    "guide_section_license__1_4": "個人での利用・カスタマイズはご自由にどうぞ。ただし",
    "guide_section_license__1_5": "再配布",
    "guide_section_license__1_6": "は禁止です。",
    "guide_section_license__1_11": "お問い合わせ",
    "guide_section_license__1_12": "フィードバック・質問・感想・ご連絡は",
    "guide_section_license__1_contact": "フィードバック・質問・感想・ご連絡は、以下の公式サイトのフォーム、またはX（旧Twitter）からもお寄せいただけます。<br>SNSリンクは公式サイト・DLページに掲載しています。",

    //フッター
    "guide_footer__1_1": "公式配布ページ：",
    "guide_footer__1_2": "最新版アップデート情報はこちらでご案内しています。",
  },

  en: {

    // ▼===使い方ガイド===▼

    // ▼ Tagflotツール一覧（テキストリンク）
    "guide_toollist_section_title": "Tagflot Tool List:",
    "guide_toolname_eagle_converter": "Category & Separator Converter Tool",

    //▼章見出し(h2)
    "guide_section_heading__basic_flow": "1. Basic Usage",
    "guide_section_heading__features": "2. Feature Descriptions",
    "guide_section_heading__advanced": "3. Advanced Usage & Customization",
    "guide_section_heading__operation": "4. Operation & Others",

    //▼1-1.tagflotについて
    "guide_intro__1_1": "1-1. About tagflot",
    "guide_intro__1_2": "What is tagflot",
    "guide_intro__1_3": "tagflot is an <strong>unofficial tagging and management tool designed for Eagle</strong>.",
    "guide_intro__1_4": "You can <strong>quickly and efficiently tag your assets</strong>.<br>Tag contents and usage are fully customizable.<br><strong>Designed to maximize the use of Eagle’s search and organization features.</strong>",
    "guide_intro__1_5": "🧩 Key Features",
    "guide_intro__1_6": "Organize tags in three levels: <strong>Group → Category → Tag</strong> to build your own classification system",
    "guide_intro__1_7": "Register combinations of tags as <strong>presets</strong> for one-click batch selection",
    "guide_intro__1_8": "Customize output format and buttons to control how tags are exported",
    "guide_intro__1_9": "Use your own tags with <strong>Eagle’s Smart Folders for auto-classification</strong>",
    "guide_intro__1_10": "<strong>No server needed. Fully local. Manual save only.</strong>",
    "guide_intro__1_11": "🧑‍💻 Perfect For...",
    "guide_intro__1_12": "If you feel you’re not making the most of tags in Eagle",
    "guide_intro__1_13": "Those who seriously want to classify, organize, and analyze videos",
    "guide_intro__1_14": "Want to use <strong>tagging as a method for adding structure and metadata</strong>",
    "guide_intro__1_15": "Want to apply meaningful tagging specifically to \“videos\” rather than still images",

    //▼1-2.初めての方へ｜基本ステップ
    "guide_basicsteps__1_1": "1-2. For First-Time Users | Basic Steps",
    "guide_basicsteps__1_2": "Basic Steps",
    "guide_basicsteps__1_3": "✨ Step 1 | Create Tags",
    "guide_basicsteps__1_4": "Use the Tag Editor Tool to create groups, categories, and tags that suit your needs.",
    "guide_basicsteps__1_5": "⚙️ Step 2 | Select & Output Tags",
    "guide_basicsteps__1_6": "Select the required tags and copy them to the clipboard.",
    "guide_basicsteps__1_7": "🏷️ Step 3 | Tag in Eagle",
    "guide_basicsteps__1_8": "Select the items you want to tag in Eagle, paste the tags into the “New Tag” search box, and the tags will be applied to the selected items.",
    "guide_basicsteps__1_9": "Use Presets for More Convenience",
    "guide_basicsteps__1_10": "Register frequently used tag sets with the “Preset Editor Tool”.",
    "guide_basicsteps__1_11": "In the “Main Tool”, just click a preset to select multiple tags at once.",

    //▼1-3.保存について
    "guide_save__1_1": "1-3. Saving, Deletion, Backups, and Creating New Files | Please Read First",
    "guide_save__1_2": "About Saving Data",
    "guide_save__1_3": "📍There is no autosave function.",
    "guide_save__1_4": "This tool runs locally using only HTML and JavaScript.<br>There is no function to automatically save your edits.",
    "guide_save__1_5": "💾How to Save Data",
    "guide_save__1_6": "At the bottom of the editor tool, click the \"Export\" button and save the file as <code>tags.js</code> or <code>presets.js</code>.<br>Overwrite the downloaded file in the <code>/data/</code> folder.<br>The process requires two steps: \"Export\" → \"Overwrite the file with the same name in the data folder\".<br><strong>After editing or overwriting data such as tags.js or presets.js, simply reload the page and the changes will be immediately reflected in the tool.</strong><br>If the changes are not reflected, please clear your browser cache and reload the page.",
    "guide_save__1_7": "📝About File Names",
    "guide_save__1_8": "The tool only loads specific file names such as “data/tags.js”, “data/presets.js”, and “data/special_tags.js”.<br>If you download or copy files multiple times, files like “tags (1).js” or “tags(2).js” may be automatically generated, but these will not be recognized by the tool.<br>When using new data, always rename your file to <code>tags.js</code>, <code>presets.js</code>, <code>special_tags.js</code>, or <code>button_toggle_category.js</code>.",
    "guide_save__1_9": "Recommended Usage",
    "guide_save__1_10": "If you frequently edit, we recommend saving your work with the “Export” button regularly.<br>When you are ready to use the final version, rename it to <code>tags.js</code> or <code>presets.js</code> and place it in the <code>data</code> folder to have it reflected in the main tool.",
    "guide_save__1_19": "Author’s Practical Example",
    "guide_save__1_20": "I always keep <code>tags.js</code> and <code>presets.js</code> open in a text editor. After editing tags or presets, I copy the output code, overwrite the file completely, and reload the tool to reflect changes instantly. I repeat this cycle to edit and check efficiently.<br>",
    "guide_save__1_11": "About Creating New Data",
    "guide_save__1_12": "✨How to Create New Data",
    "guide_save__1_13": "If you want to start over and create new tags or presets, delete <code>tags.js</code> and <code>presets.js</code> from the <code>data</code> folder and launch each editor tool.<br>If the file does not exist, a “Create New Data” dialog will appear, and you can start from a blank state.<br>Even if you create or download new data, existing files will never be automatically overwritten or deleted.<br>You can use this function with confidence for data cleanup or resetting.<br>For more detailed instructions, please refer to the tag editor and preset editor usage guides.",
    "guide_save__1_14": "About Backup",
    "guide_save__1_15": "💿How to Backup",
    "guide_save__1_16": "All tag and preset data is stored in the <code>data</code> folder.<br>To be safe, copy the entire <code>data</code> folder to easily create a backup.<br>If you want to back up individual files, you can save them in the same folder under a different name, such as <code>tags_backup.js</code>, without any problems.<br>Backup files and past data will remain unless you delete them manually, so you can restore or manage them as needed.",
    "guide_save__1_17": "🗑️How to Delete",
    "guide_save__1_18": "To delete this tool, simply delete the entire folder.<br>No registry or system settings are ever modified.",

    //▼1-4.各ページの役割と使い分け
    "guide_roles__1_1": "1-4. Tool Roles & Usage",
    "guide_roles__1_2": "About Each Tool",
    "guide_roles__1_3": "🛠️ Tag Editor Tool (tag_editor.html)",
    "guide_roles__1_4": "This tool is used for “adding, organizing, and editing” tags.<br>If you don’t create tags yourself, they won’t appear in the main tool.<br>(*Some demo tags are preloaded on first use.)",
    "guide_roles__1_5": "🧩 Preset Editor Tool (preset_editor.html)",
    "guide_roles__1_6": "Create presets by bundling multiple tags for one-click application.<br>Great for saving time or reusing common tag sets.",
    "guide_roles__1_7": "🏷️ Main Tool (tagflot.html)",
    "guide_roles__1_8": "This tool is used to select and export tags and presets you’ve registered.",
    "guide_roles__1_9": "🧰 TSV/JS Converter Tool (tool_convert_tsv_to_js.html)",
    "guide_roles__1_10": "This helper tool converts tag/preset definitions between table format (TSV) and JavaScript (tags.js/presets.js).<br>It makes importing from Excel or managing exported data easy.",

    //▼2-1.タグ編集ツールの使い方
    "guide_tag_editor__1_1": "2-1. How to Use the Tag Editor Tool (tag_editor.html)",
    "guide_tag_editor__1_2": "Basic Usage (Steps to Create Tags)",
    "guide_tag_editor__1_3": "Creating and Editing Tags",
    "guide_tag_editor__1_4": "Tags are managed in a three-level hierarchy: Group - Category - Tag.<br>",
    "guide_tag_editor__1_5": "Saving and Applying",
    "guide_tag_editor__1_6": "After completing your tags, save them as tags.js and overwrite <code>/data/tags.js</code>.",
    "guide_tag_editor__1_23": "About Creating New Data",
    "guide_tag_editor__1_24": "If you delete the existing tag data file (<code>tags.js</code>) and open the editor tool, you can freely add groups, categories, and tags from a blank state.<br>If the data file does not exist in the <code>data</code> folder, the tool will automatically prompt you to create new data.<br>This feature is also useful when you want to reset all data during editing or organizing.<br>If you want to keep the original file, please rename it (e.g., <code>tags_backup.js</code>) or move it to another folder for backup.",
    "guide_tag_editor__1_7": "Note｜About Saving",
    "guide_tag_editor__1_8": "※ The main tool will not reflect changes unless you overwrite or replace <code>/data/tags.js</code>.",
    "guide_tag_editor__1_9": "Key Features",
    "guide_tag_editor__1_10": "Using Short Labels",
    "guide_tag_editor__1_11": "Short labels are abbreviated names for button display, used when the display would otherwise break (they do not affect output).<br>Normally, you do not need to set this.",
    "guide_tag_editor__1_12": "Group Color Reflection",
    "guide_tag_editor__1_13": "The group color is reflected in the \"category left band\" and \"description table\" of the main tool.",
    "guide_tag_editor__1_14": "About Special Tags",
    "guide_tag_editor__1_15": "Special Tag Display Settings",
    "guide_tag_editor__1_16": "You can toggle the display of special tags that are common to each category, such as \"Unselected\", \"Not Applicable\", and \"Other\".",
    "guide_tag_editor__1_17": "Specification of 'Unselected'",
    "guide_tag_editor__1_18": "\"Unselected\" is always displayed and also functions as a reset button for tag selection in each category.<br>You can choose whether to include it in the output.",
    "guide_tag_editor__1_19": "Adding Special Tags",
    "guide_tag_editor__1_20": "If you want to display a special tag across multiple categories, you can add it as a custom special tag.<br>Details on how to add them are described in Section 3.",
    "guide_tag_editor__1_21": "Changing the Label or Description of Special Tags",
    "guide_tag_editor__1_22": "If you want to change the display name or description of existing or custom special tags, edit the settings file.<br>The editing procedure is explained in Section 3.",


    //▼2-2.プリセット編集ツールの使い方
    "guide_preset_editor__1_1": "2-2. How to Use the Preset Editor Tool (preset_editor.html)",
    "guide_preset_editor__1_2": "Basic Usage (Steps to Register Presets)",
    "guide_preset_editor__1_3": "Creating and Editing Groups and Categories",
    "guide_preset_editor__1_4": "Create groups and categories for presets.",
    "guide_preset_editor__1_5": "Creating and Editing Presets",
    "guide_preset_editor__1_6": "Create presets by selecting tags from the registered ones.<br>You can also add or remove tags from a preset later.",
    "guide_preset_editor__1_7": "Organizing and Editing Order",
    "guide_preset_editor__1_8": "Sort the order of presets and delete or move them as needed.",
    "guide_preset_editor__1_9": "Detecting and Removing Undefined Tags",
    "guide_preset_editor__1_10": "If the ID of a tag in a preset is changed or deleted, a notice appears on any presets, categories, or groups that include the now “undefined” tag.<br>There’s also a button to auto-open presets containing undefined tags.<br>Please remove them.<br>The broken ID will be shown, so you can refer to it when re-adding the tag.",
    "guide_preset_editor__1_11": "Saving Presets",
    "guide_preset_editor__1_12": "Save the completed data as <code>presets.js</code>.<br>Overwrite <code>/data/presets.js</code> with it.",
    "guide_preset_editor__1_22": "About Creating New Data",
    "guide_preset_editor__1_23": "If you delete the existing preset data file (<code>presets.js</code>) and open the preset editor tool, you can freely add groups, categories, and presets from a blank state.<br>If the data file does not exist in the <code>data</code> folder, the tool will automatically prompt you to create new data.<br>This feature is also useful when you want to reset all data during editing or organizing.<br>If you want to keep the original file, please rename it (e.g., <code>presets_backup.js</code>) or move it to another folder for backup.",
    "guide_preset_editor__1_13": "Note on Saving",
    "guide_preset_editor__1_14": "* Changes won’t appear in the main tool unless <code>/data/presets.js</code> is overwritten or replaced.",
    "guide_preset_editor__1_15": "Key Features of Each Function",
    "guide_preset_editor__1_16": "Short Label Specification",
    "guide_preset_editor__1_17": "Short labels are used when preset names are long; they affect button display only.",
    "guide_preset_editor__1_18": "Group Color Reflection",
    "guide_preset_editor__1_19": "Group colors appear in the “description table” of the main tool.",
    "guide_preset_editor__1_20": "Favorite Flag Behavior",
    "guide_preset_editor__1_21": "If a preset has the favorite flag (★), it will show a star mark at the top-right corner in the main tool.",

    //▼2-3.メインツールの使い方（tagflot.html）
    "tagflot_feature_usage__1_1": "2-3. How to Use the Main Tool (tagflot.html)",
    "tagflot_feature_usage__1_2": "Basic Usage",
    "tagflot_feature_usage__1_3": "Tag Selection",
    "tagflot_feature_usage__1_4": "Click on tag or preset buttons to select tags.",
    "tagflot_feature_usage__1_5": "Output Settings",
    "tagflot_feature_usage__1_6": "Use the bottom-right output settings panel to choose format, range, etc.",
    "tagflot_feature_usage__1_7": "Copying Tags",
    "tagflot_feature_usage__1_8": "Click the copy button to copy selected tags to the clipboard.<br>You can paste them into the text area below the tag table to review.<br>The reset button below clears the pasted content.",
    "tagflot_feature_usage__1_9": "Applying Tags in Eagle",
    "tagflot_feature_usage__1_10": "Paste into Eagle’s “New Tag” field to apply tags.",
    "tagflot_feature_usage__1_11": "Key Feature Highlights",
    "tagflot_feature_usage__1_12": "📦 About Presets",
    "tagflot_feature_usage__1_13": "Selecting Presets",
    "tagflot_feature_usage__1_14": "Clicking a preset adds its tags to the current selection.<br>Already selected tags are not duplicated.",
    "tagflot_feature_usage__1_15": "Toggle Preset Panel",
    "tagflot_feature_usage__1_16": "Toggle the preset area using the button at the top right.",
    "tagflot_feature_usage__1_17": "Expand/Collapse All Groups and Categories",
    "tagflot_feature_usage__1_18": "Use the OPEN/CLOSE buttons to toggle all groups and categories at once.",
    "tagflot_feature_usage__1_19": "Favorite Preset Star Display",
    "tagflot_feature_usage__1_20": "Presets marked as favorites display a ★ in the top right corner.<br>Favorites can be set in the Preset Editor Tool.",
    "tagflot_feature_usage__1_21": "View Preset Details",
    "tagflot_feature_usage__1_22": "Hovering over a preset shows its tag list in a central popup.",
    "tagflot_feature_usage__1_23": "⚙️ Output Options",
    "tagflot_feature_usage__1_24": "Output & Behavior Settings",
    "tagflot_feature_usage__1_25": "You can choose from the following three output formats:<br>・Category Label : Tag Label<br>・Category ID : Tag Label<br>・Tag Label only<br>* Even if a short label is set, the tag label will be output.",
    "tagflot_feature_usage__1_26": "Target Output Selection",
    "tagflot_feature_usage__1_27": "You can choose to output tags from only open categories or from all categories.<br>You can also choose whether to include unselected tags.",
    "tagflot_feature_usage__1_28": "Show Tag Descriptions in Popups",
    "tagflot_feature_usage__1_29": "Hovering displays a tooltip with the tag/category description.<br>You can turn this feature on or off in the settings.",
    "tagflot_feature_usage__1_30": "Click Sound Settings",
    "tagflot_feature_usage__1_31": "Click sound effects can be turned on or off.<br>This setting is saved automatically in your browser.",
    "tagflot_feature_usage__1_32": "Save Output Settings",
    "tagflot_feature_usage__1_33": "Output format, range, tooltip display, and click sound settings are saved in your browser.<br>There’s also a reset button for settings.",
    "tagflot_feature_usage__1_34": "📖 About the Button List",
    "tagflot_feature_usage__1_35": "Toggle Button List Column",
    "tagflot_feature_usage__1_36": "You can use the button at the top left of the screen to show or hide the button list column.",
    "tagflot_feature_usage__1_37": "Button List",
    "tagflot_feature_usage__1_38": "The labels and contents of each button are displayed in a table format.",
    "tagflot_feature_usage__1_39": "Expand/Collapse All Groups and Categories",
    "tagflot_feature_usage__1_40": "Use OPEN/CLOSE buttons to toggle all groups and categories at once.",
    "tagflot_feature_usage__1_41": "🏷️ About Tag Selection",
    "tagflot_feature_usage__1_42": "Tag Selection Display",
    "tagflot_feature_usage__1_43": "Selected tags appear at the bottom of the screen. Click to jump to their category.<br>You can remove individual tags using the × button shown on hover.",
    "tagflot_feature_usage__1_44": "About the “Unselected” Button",
    "tagflot_feature_usage__1_45": "Initially, each category’s “Unselected” button is selected.<br>Clicking it after choosing tags will clear all selections in that category.",
    "tagflot_feature_usage__1_46": "📝 About the Code Generation Area",
    "tagflot_feature_usage__1_47": "Click the “＋” button below the tag table to open the code generation area.<br>You can generate code for direct editing or output tag/preset lists.<br>See Section 3 for details and precautions.",

    //▼2-4.TSV/JS変換ツールの使い方
    "converter_feature_usage__1_1": "2-4. How to Use the TSV/JS Conversion Tool (tool_convert_tsv_to_js.html)",
    "converter_feature_usage__1_2": "Basic Usage",
    "converter_feature_usage__1_3": "Overview",
    "converter_feature_usage__1_4": "This tool converts tab-separated (TSV) tag and preset data into the internal tags.js / presets.js format. Useful for bulk editing with Excel or Google Sheets.",
    "converter_feature_usage__1_5": "Main Use Cases",
    "converter_feature_usage__1_6": "・When you want to bulk-create many tags or presets・When importing shared spreadsheets edited by multiple people・When batch-generating presets with similar structures",
    "converter_feature_usage__1_7": "How to Use",
    "converter_feature_usage__1_8": "1. Export tag/preset data as TSV from the main tool and edit it in Excel or Google Sheets. You may also download it as CSV and edit it in a text editor. 2. Load the edited data via CSV upload or paste from spreadsheet cells. 3. Click the \"Convert\" button to generate the output code, and paste it into tags.js or presets.js.",
    "converter_feature_usage__1_9": "Input & Output Format",
    "converter_feature_usage__1_10": "Input Guidelines",
    "converter_feature_usage__1_11": "Label and ID are required. IDs must begin with specific prefixes: preset-gp__, tagu-gp__, preset__, tag__, or {categoryID}__. Valid characters: alphanumeric and underscore (_) only. Avoid double underscores, or leading/trailing underscores.",
    "converter_feature_usage__1_12": "Error Notification",
    "converter_feature_usage__1_13": "If input contains errors, a warning is displayed. Output will not be generated.",
    "converter_feature_usage__1_14": "Output Handling",
    "converter_feature_usage__1_15": "The generated code can be pasted directly into tags.js or presets.js. You can also copy it to the clipboard or download it.",
    "converter_feature_usage__1_16": "Tips",
    "converter_feature_usage__1_17": "TSV format includes full internal IDs with prefixes. The editing tools allow entering only the suffix portion. For restructuring (e.g. adding groups, reassigning categories), editing tools are recommended.",

    //▼2-5.アップデート通知機能について
    "guide_update_notify__1_1": "2-5. About the Update Notification Feature",
    "guide_update_notify__1_2": "About the Update Notification Feature",
    "guide_update_notify__1_3": "Click the <strong>Update Notification</strong> button at the bottom-right of the main tool to check for the latest news anytime.<br>(Requires internet connection / No external data is sent.)",
    "guide_update_notify__1_4": "🔃 How to Carry Over Data During Updates",
    "guide_update_notify__1_5": "To migrate to a new version of tagflot, simply overwrite the files (e.g. tags.js, presets.js) in the <code>data</code> folder of the new version with your current files.<br>* If the data format changes in the future, a dedicated converter tool will be provided.",

    //▼3-1.コード生成の使い方
    "guide_section_codegen__1_1": "3-1. How to Use Code Generation",
    "guide_section_codegen__1_2": "How to Use the Code Generation Feature",
    "guide_section_codegen__1_3": "In the <strong>Code Generation Corner</strong>, you can generate various code snippets for tags, presets, groups, and categories, and output a <strong>list of currently used tags and presets (in tab-separated or CSV format)</strong>.<br>* Tags and presets can be added/edited through the GUI, but manual code generation and data exports are also available when needed.<br>How to use the <strong>Category Toggle Button Generator</strong> is explained in a dedicated section.",
    "guide_section_codegen__1_4": "📤 How to Export Tag/Preset Lists",
    "guide_section_codegen__1_5": "1. Export the current tag/preset list from the main tool.",
    "guide_section_codegen__1_6": "2. Copy the exported data and paste it into Excel or save it as a CSV file to edit.",
    "guide_section_codegen__1_7": "3. Paste the edited content into the <strong>Converter Tool</strong> to convert.",
    "guide_section_codegen__1_8": "4. Overwrite the generated <code>tags.js</code> or <code>presets.js</code> in the <strong>data folder</strong>, or paste the contents into the existing files and save.",
    "guide_section_codegen__1_9": "⚠️ Notes",
    "guide_section_codegen__1_10": "This export is a <strong>support feature to list the currently used data</strong>.",
    "guide_section_codegen__1_11": "Changes to tag names or structure are not reflected automatically. You must re-export and re-convert after editing.",

    //▼3-2カテゴリ操作ボタンの使い方・追加方法
    "guide_section_category_toggle__1_1": "3-2. How to Use and Add Category Toggle Buttons",
    "guide_section_category_toggle__1_2": "How to Use Category Toggle Buttons",
    "guide_section_category_toggle__1_3": "🗂️ What Are Category Toggle Buttons?",
    "guide_section_category_toggle__1_4": "Category toggle buttons allow you to open/close or sort multiple categories with a single button.<br>There are “Standard Buttons” and “Custom Toggle Buttons.”",
    "guide_section_category_toggle__1_5": "🔘 Standard Button Specifications",
    "guide_section_category_toggle__1_6": "* Button names and descriptions may vary slightly depending on language settings.",
    "guide_section_category_toggle__1_7": "Custom Category Toggle Buttons",
    "guide_section_category_toggle__1_8": "⭐ What Are Custom Category Toggle Buttons?",
    "guide_section_category_toggle__1_9": "Custom category toggle buttons let you <strong>open or close multiple categories at once</strong>.<br>Useful if you frequently use certain categories or want to switch by context.",
    "guide_section_category_toggle__1_10": "🛠️ How to Create",
    "guide_section_category_toggle__1_11": "1. Set only the desired categories to “open”<br>2. In the main tool’s code generation form, enter a “name” and “ID” (e.g., open_char)<br>3. Click “Generate Category Toggle Button” to get the code<br>4. Paste it into button_toggle_category.js and save to complete",
    "guide_section_category_toggle__1_12": "⚠️ Notes",
    "guide_section_category_toggle__1_13": "An automatic prefix is added to the ID.<br>Do not modify it.<br>(e.g., tagCategoryToggle__open_char)<br>Below is an example definition for one button.",
    "guide_section_category_toggle__1_14": "🔢 Example Custom Group Structure",
    "guide_section_category_toggle__1_15": "Groups are separated with commas <code>,</code>, and you can freely add or rearrange them.<br>Standard groups (like openAll or closeAll) can be deleted if not needed.",

    //▼3-3.特殊タグの使い方・追加方法
    "guide_section_special_tags__1_1": "3-3. How to Use and Add Special Tags",
    "guide_section_special_tags__1_2": "About Special Tags",
    "guide_section_special_tags__1_3": "🔖 What Are Special Tags?",
    "guide_section_special_tags__1_4": "Special tags can be used across all categories.<br><strong>Standard special tags<\/strong> (\"Unselected\"\, \"Not Applicable\"\, \"Other\") are shared globally.<br>You can toggle their visibility, but <strong>you cannot change their name, description, or ID</strong>.<br>The “Unselected” tag cannot be hidden.",
    "guide_section_special_tags__1_5": "Custom Special Tags",
    "guide_section_special_tags__1_6": "⭐ What Are Custom Special Tags?",
    "guide_section_special_tags__1_7": "You can create your own special tags that appear across multiple categories.<br>Visibility per category can be toggled in the tag editor, just like standard ones.",
    "guide_section_special_tags__1_8": "🛠️ How to Add Custom Special Tags",
    "guide_section_special_tags__1_9-1": "Please copy and reuse the standard tag format from /data/special_tag_settings.js.",
    "guide_section_special_tags__1_9-2": "Use <strong>idSuffix</strong> as the ID using alphanumerics and underscores only. Follow the format <code>special_tag__A</code>. Do not use underscores at the beginning or end, and avoid double underscores (__). Make sure it doesn’t duplicate existing tags.",
    "guide_section_special_tags__1_9-3": "Enter the <strong>defaultLabel</strong> (required tag name) and <strong>description</strong> (optional note or explanation).",
    "guide_section_special_tags__1_10": "Sample (1 custom tag):",
    "guide_section_special_tags__1_11": "🔢 Full Example of special_tag_settings.js",
    "guide_section_special_tags__1_12": "* The 3 standard tags (\"Unselected\", \"Not Applicable\", \"Other\") cannot be modified.<br>Add custom special tags in the same format.<br>Be careful with commas when adding.",

    //▼3-4.効果的な使い方・活用術
    "guide_section_tips__1_1": "3-4. Effective Usage & Tips",
    "guide_section_tips__1_2": "Effective Usage & Tips",
    "guide_section_tips__1_3": "🗂️ Bulk Toggle by Type",
    "guide_section_tips__1_4": "Register needed categories for each video type using “Custom Toggle Buttons.”<br>When exporting, choose “Only Open Categories” to efficiently manage tags by type.",
    "guide_section_tips__1_5": "➖ Using the “Unselected” Tag",
    "guide_section_tips__1_6": "By including the \"Unselected\" tag in the output, you can clearly distinguish whether:<br>- the tag was deliberately left out<br>- or it simply hasn't been decided yet.<br>This helps improve the reliability of your data.",
    "guide_section_tips__1_7": "📦 Mass Tagging with Presets",
    "guide_section_tips__1_8": "Using presets allows one-click selection of commonly used tag sets,<br>making detailed video logging and organization dramatically more efficient.",
    "guide_section_tips__1_9": "💡 Using Eagle’s Smart Folders",
    "guide_section_tips__1_10": "Combining tag/preset-based classification with Eagle’s Smart Folders allows quick filtering of needed assets or videos.",

    //▼3-5.効果的な使い方・活用術
    "guide_section_faq__1_1": "The Supplement & Materials",
    "guide_section_faq__1_2": "About the Icons",
    "guide_section_faq__1_3": "The distribution package includes icon files (Windows ICO and Mac ICNS) in the <code>docs/image/</code> folder.<br>Please use these images if you want to use the tool's icons.",

    //▼3-6.Eagle側のカテゴリ名・区切りの変換について

    "guide_related_tools__1_1": "3-6.Eagle Tag Conversion (Category Names & Separators)",
    "guide_related_tools__1_2": "Eagle Tag Converter",
    "guide_related_tools__1_3": "Overview",
    "guide_related_tools__1_4": "This desktop app lets you batch-convert existing Eagle tags<br>to match tagflot’s output formats (no category name / ： / _ / __).",
    "guide_related_tools__1_5": "Features",
    "guide_related_tools__1_6": "・Batch convert separators between category name and tags<br>・Batch rename category names<br><strong>Includes backup/restore for safer use.</strong><br>※This is an unofficial tool. Please use it at your own risk.",
    "guide_related_tools__1_7": "Details & Download",
    "guide_related_tools__1_8": "For detailed information and the latest download, please visit the tagflot distribution page.<br>▶︎ <a href=\"https://flotidot.com/tools/tagflot/index.html\" target=\"_blank\">Eagle Tag Converter (tagflot page)</a>",
    //▼4-1.このツールを作った理由
    "guide_section_motivation__1_1": "4-1. Why I Made This Tool",
    "guide_section_motivation__1_2": "Why I Made This Tool",
    "guide_section_motivation__1_3": "I want to organize my references, but I'm not good at categorizing or tagging, so I always get stuck.<br>This personal struggle led to the creation of this tool.",
    "guide_section_motivation__1_4": "Even after collecting reference videos, I found they weren’t organized when I looked back later.<br>I realized the system—not the content—was to blame.<br>So I decided to make a tool that felt intuitive to me.",
    "guide_section_motivation__1_5": "The UI, layout, and output formats are all designed based on how I actually use them.<br>While it’s made for personal use, I hope it helps others organize too.",
    "guide_section_motivation__1_5b": "In reality, this tool became an extension of my hobby and playful spirit, and I ended up adding far too many features.<br>I really didn’t need to make it this elaborate—but here we are!<br>I hope someone finds it useful.",
    "guide_section_motivation__1_6": "Finally, I sincerely thank the developers of Eagle for creating such an excellent tool.",
    "guide_section_motivation__1_7": "July 15, 2025<br><strong>Avery</strong>",

    //▼4-2.多言語対応について
    "guide_section_language__1_1": "4-2. About Multilingual Support",
    "guide_section_language__1_2": "About Multilingual Support",
    "guide_section_language__1_3": "You can switch between Japanese, English, and Traditional Chinese using the language selector at the top right of the screen.<br>Translations are done using both AI and manual input, so please excuse any inconsistencies in wording or quality.<br>Traditional Chinese is included since Eagle is software from Taiwan.<br>Other languages may be added or removed at random in the future.",
    "guide_section_language__1_4": "⚠️ Note on Language Switching",
    "guide_section_language__1_5": "If parts of the UI do not update after switching languages in the dropdown, try reloading the page to apply changes correctly.",

    //▼4-3.バージョン情報
    "guide_section_version": "4-3. Version Information",
    "guide_version_note": "* This section is available in Japanese only.",

    //▼4-4.ライセンス・利用条件・コンタクト
    "guide_section_license__1_1": "4-4. License / Terms of Use / Contact",
    "guide_section_license__1_2": "License / Terms of Use / Contact",
    "guide_section_license__1_3": "Copyright of this tool and guide belongs to the developer (Avery).",
    "guide_section_license__1_4": "Personal use and customization are allowed freely, however,",
    "guide_section_license__1_5": "redistribution",
    "guide_section_license__1_6": "is prohibited.",
    "guide_section_license__1_11": "Contact",
    "guide_section_license__1_12": "For feedback, questions, comments, or contact,",
    "guide_section_license__1_contact": "For feedback, questions, or comments, please use the form on the official website below, or contact via X (formerly Twitter).<br>SNS links are available on the official site and download page.",

    //フッター
    "guide_footer__1_1": "Official Download Page:",
    "guide_footer__1_2": "Latest update information is provided here.",
  },

  zh_TW: {

    // ▼===使い方ガイド===▼

    // ▼ Tagflotツール一覧（テキストリンク）
    "guide_toollist_section_title": "Tagflot 工具清單：",
    "guide_toolname_eagle_converter": "類別名稱與分隔符轉換工具",

    //▼章見出し(h2)
    "guide_section_heading__basic_flow": "1. 基本使用方式",
    "guide_section_heading__features": "2. 各項功能說明",
    "guide_section_heading__advanced": "3. 進階用法與自訂功能",
    "guide_section_heading__operation": "4. 操作與其他",

    //▼1-1.tagflotについて
    "guide_intro__1_1": "1-1. 關於 tagflot",
    "guide_intro__1_2": "什麼是 tagflot",
    "guide_intro__1_3": "tagflot 是一款<strong>專為 Eagle 設計的非官方標籤與管理工具</strong>。",
    "guide_intro__1_4": "可<strong>快速且大量地為素材加上標籤</strong>。<br>標籤內容與用法皆可依使用者需求自訂。<br><strong>設計上可充分發揮 Eagle 的搜尋與管理功能。</strong>",
    "guide_intro__1_5": "🧩 主要特色",
    "guide_intro__1_6": "以 <strong>群組 → 類別 → 標籤</strong> 的三層結構整理標籤，建立專屬的分類系統",
    "guide_intro__1_7": "將多個標籤組合儲存為<strong>預設</strong>，即可一鍵快速選取多個標籤",
    "guide_intro__1_8": "可自訂輸出格式與按鈕，控制標籤的輸出方式",
    "guide_intro__1_9": "可搭配 <strong>Eagle 的智慧型資料夾</strong> 使用自定義標籤，進行自動分類",
    "guide_intro__1_10": "<strong>不需伺服器、完全本機執行（需手動儲存）</strong>",
    "guide_intro__1_11": "🧑‍💻 適合對象",
    "guide_intro__1_12": "覺得自己在 Eagle 中無法充分利用標籤者",
    "guide_intro__1_13": "想要認真地對影片進行分類、整理與分析的人",
    "guide_intro__1_14": "希望將<strong>標籤視為資訊賦予與結構化的手段</strong>",
    "guide_intro__1_15": "想要針對「影片」進行標籤賦意，而非僅限於靜態圖像",

    //▼1-2.初めての方へ｜基本ステップ
    "guide_basicsteps__1_1": "1-2. 初次使用者指南｜基本步驟",
    "guide_basicsteps__1_2": "基本步驟",
    "guide_basicsteps__1_3": "✨ 第一步｜建立標籤",
    "guide_basicsteps__1_4": "使用標籤編輯工具建立符合自己需求的群組、類別與標籤。",
    "guide_basicsteps__1_5": "⚙️ 第二步｜選擇並輸出標籤",
    "guide_basicsteps__1_6": "選擇需要的標籤，並複製到剪貼簿。",
    "guide_basicsteps__1_7": "🏷️ 第三步｜在 Eagle 中套用標籤",
    "guide_basicsteps__1_8": "在 Eagle 中選取您想標記的項目，將標籤貼到「新增標籤」的搜尋欄，即可將標籤套用到所選項目上。",
    "guide_basicsteps__1_9": "想要更方便地使用｜請活用預設功能",
    "guide_basicsteps__1_10": "使用「預設編輯工具」將常用標籤組合註冊為預設。",
    "guide_basicsteps__1_11": "在「主工具」中，只需點擊預設，即可一次選取多個標籤。",

    //▼1-3.保存について
    "guide_save__1_1": "1-3. 保存、刪除、備份、新建資料｜請務必閱讀",
    "guide_save__1_2": "關於儲存",
    "guide_save__1_3": "📍沒有自動儲存功能",
    "guide_save__1_4": "本工具僅使用HTML和JavaScript在本地運行。<br>編輯內容不會自動儲存。",
    "guide_save__1_5": "💾儲存方法",
    "guide_save__1_6": "在编辑工具底部点击「导出」按钮，将文件保存为 <code>tags.js</code> 或 <code>presets.js</code>。<br>请将下载的文件覆盖保存到 <code>/data/</code> 文件夹中。<br>操作分为两步：“导出” → “在 data 文件夹中用同名文件覆盖保存”。<br><strong>编辑或覆盖 tags.js、presets.js 等数据后，刷新页面即可立即反映到工具中。</strong><br>如果没有反映，请清除浏览器缓存后重新加载页面。",
    "guide_save__1_7": "📝關於檔案名稱",
    "guide_save__1_8": "工具只會自動讀取特定檔案名稱，例如「data/tags.js」、「data/presets.js」、「data/special_tags.js」等。<br>重複下載或複製時，可能會自動生成「tags (1).js」或「tags(2).js」這樣的檔案，但這些檔案工具不會識別。<br>使用新資料時，請務必將檔案名稱改成<code>tags.js</code>、<code>presets.js</code>、<code>special_tags.js</code>或<code>button_toggle_category.js</code>。",
    "guide_save__1_9": "推薦使用方法",
    "guide_save__1_10": "如果您經常編輯，建議隨時使用「匯出」按鈕保存進度。<br>最終版請改名為<code>tags.js</code>或<code>presets.js</code>並放到<code>data</code>資料夾，即可立即在主工具上生效。",
    "guide_save__1_19": "製作者的實踐例",
    "guide_save__1_20": "我會一直用文字編輯器打開 <code>tags.js</code> 和 <code>presets.js</code>，每次編輯標籤或預設後，就把輸出的程式碼整段複製覆蓋存檔，再重新載入工具，馬上就能看到變化。如此來回編輯和確認。",
    "guide_save__1_11": "關於新建資料",
    "guide_save__1_12": "✨如何建立新資料",
    "guide_save__1_13": "如果想要從頭開始重新建立標籤或預設組合，請將<code>tags.js</code>和<code>presets.js</code>從<code>data</code>資料夾刪除，再啟動各個編輯工具。<br>若檔案不存在，將會顯示「新建資料對話框」，讓您從空白狀態開始建立。<br>新建或下載資料時，既有檔案不會被自動覆蓋或刪除。<br>您可以安心用於資料整理或重設。<br>詳細步驟請參考標籤編輯工具與預設編輯工具的說明。",
    "guide_save__1_14": "關於備份",
    "guide_save__1_15": "💿備份方法",
    "guide_save__1_16": "所有標籤與預設資料都保存在<code>data</code>資料夾。<br>為了以防萬一，建議複製整個<code>data</code>資料夾以快速完成備份。<br>如果要單獨備份檔案，可以用不同的名稱（如<code>tags_backup.js</code>）儲存在同一資料夾內，這樣完全沒問題。<br>備份檔案和過去資料只要未手動刪除，皆會保留，可隨時復原或管理。",
    "guide_save__1_17": "🗑️刪除方法",
    "guide_save__1_18": "若要移除本工具，只需將整個資料夾刪除即可。<br>不會有任何登錄檔或系統設定的寫入。",

    //▼1-4.各ページの役割と使い分け
    "guide_roles__1_1": "1-4. 各工具的功能與使用方式",
    "guide_roles__1_2": "關於各個工具",
    "guide_roles__1_3": "🛠️ 標籤編輯工具（tag_editor.html）",
    "guide_roles__1_4": "此工具專門用於「新增、整理、編輯」標籤。<br>若不自行建立標籤，主工具中將無法顯示。<br>（※初次使用會預先載入幾個示範標籤）",
    "guide_roles__1_5": "🧩 預設編輯工具（preset_editor.html）",
    "guide_roles__1_6": "可將多個標籤打包成一組預設，讓您一鍵套用。<br>適合希望節省標籤作業時間，或常用組合標籤的使用者。",
    "guide_roles__1_7": "🏷️ 主工具（tagflot.html）",
    "guide_roles__1_8": "此工具用於實際選取並輸出已登錄的標籤與預設。",
    "guide_roles__1_9": "🧰 TSV/JS 轉換工具（tool_convert_tsv_to_js.html）",
    "guide_roles__1_10": "本輔助工具可在標籤／預設定義的表格格式（TSV）與 JavaScript（tags.js/presets.js）之間進行轉換。<br>可輕鬆匯入 Excel 編輯內容，或管理輸出資料。",

    //▼2-1.タグ編集ツールの使い方
    "guide_tag_editor__1_1": "2-1. 標籤編輯工具的使用方法（tag_editor.html）",
    "guide_tag_editor__1_2": "基本用法（建立標籤的步驟）",
    "guide_tag_editor__1_3": "標籤的建立與編輯",
    "guide_tag_editor__1_4": "以群組－分類－標籤三層結構來管理。<br>",
    "guide_tag_editor__1_5": "儲存與套用",
    "guide_tag_editor__1_6": "完成的標籤請儲存為 tags.js 並覆蓋 <code>/data/tags.js</code>。",
    "guide_tag_editor__1_23": "新建資料說明",
    "guide_tag_editor__1_24": "刪除既有的標籤資料（<code>tags.js</code>）後開啟編輯工具，即可從空白狀態開始自由新增群組、分類和標籤。<br>若<code>data</code>資料夾中沒有資料檔案，也會自動顯示新建資料畫面。<br>需要在編輯或整理時將全部資料重設為初始狀態時也很適合使用。<br>如果想保留原有檔案，請先更名（如：<code>tags_backup.js</code>），或將檔案移至其他資料夾備份保存。",
    "guide_tag_editor__1_7": "注意｜關於儲存",
    "guide_tag_editor__1_8": "※除非將 <code>/data/tags.js</code> 覆蓋或替換，否則主工具無法套用變更。",
    "guide_tag_editor__1_9": "各功能重點",
    "guide_tag_editor__1_10": "短標籤的使用",
    "guide_tag_editor__1_11": "短標籤是用於按鈕顯示的簡短名稱，當顯示有崩壞時可使用（不影響輸出）。<br>通常不需要設定。",
    "guide_tag_editor__1_12": "群組顏色的反映",
    "guide_tag_editor__1_13": "群組顏色會反映在主工具的「分類左側條」和「說明表」中。",
    "guide_tag_editor__1_14": "關於特殊標籤",
    "guide_tag_editor__1_15": "特殊標籤顯示設定",
    "guide_tag_editor__1_16": "可切換各分類通用的特殊標籤（如「未選擇」「不適用」「其他」）的顯示/隱藏。",
    "guide_tag_editor__1_17": "未選擇的規格",
    "guide_tag_editor__1_18": "「未選擇」會一直顯示，也可作為每個分類的標籤選擇重設按鈕。<br>可設定是否包含於輸出。",
    "guide_tag_editor__1_19": "新增特殊標籤",
    "guide_tag_editor__1_20": "如需在多個分類通用顯示特殊標籤，可作為自訂特殊標籤新增。<br>新增方法詳見第3節。",
    "guide_tag_editor__1_21": "修改特殊標籤名稱／內容",
    "guide_tag_editor__1_22": "若要變更既有或自訂特殊標籤的顯示名稱或說明文字，請編輯設定檔。<br>編輯方法於第3節說明。",


    //▼2-2.プリセット編集ツールの使い方
    "guide_preset_editor__1_1": "2-2. 預設編輯工具的使用方式（preset_editor.html）",
    "guide_preset_editor__1_2": "基本使用方式（登錄預設的步驟）",
    "guide_preset_editor__1_3": "建立與編輯群組與類別",
    "guide_preset_editor__1_4": "建立用於預設的群組與類別。",
    "guide_preset_editor__1_5": "建立與編輯預設",
    "guide_preset_editor__1_6": "從已登錄的標籤中選擇所需標籤建立預設。<br>之後也可新增或刪除預設中包含的標籤。",
    "guide_preset_editor__1_7": "整理與編輯順序",
    "guide_preset_editor__1_8": "整理預設的順序，並視需要刪除或移動。",
    "guide_preset_editor__1_9": "偵測與刪除未定義標籤",
    "guide_preset_editor__1_10": "若預設中所使用的標籤 ID 已變更或被刪除，將會在包含該「未定義標籤」的預設、類別或群組中顯示通知。<br>也提供一鍵展開含有未定義標籤之預設的按鈕。<br>請務必刪除未定義標籤。<br>畫面上會顯示斷開的 ID，可參考此資訊直接新增標籤。",
    "guide_preset_editor__1_11": "儲存預設",
    "guide_preset_editor__1_12": "將完成的資料儲存為 <code>presets.js</code>，<br>並覆蓋至 <code>/data/presets.js</code>。",
    "guide_preset_editor__1_22": "新建資料說明",
    "guide_preset_editor__1_23": "刪除既有的預設資料（<code>presets.js</code>）後開啟預設編輯工具，即可從空白狀態開始自由新增群組、分類和預設。<br>若<code>data</code>資料夾中沒有資料檔案，也會自動顯示新建資料畫面。<br>需要在編輯或整理時將全部資料重設為初始狀態時也很適合使用。<br>如果想保留原有檔案，請先更名（如：<code>presets_backup.js</code>），或將檔案移至其他資料夾備份保存。",
    "guide_preset_editor__1_13": "注意事項｜關於儲存",
    "guide_preset_editor__1_14": "※ 若未覆蓋或替換 <code>/data/presets.js</code>，主工具中將無法反映變更。",
    "guide_preset_editor__1_15": "各功能的重點",
    "guide_preset_editor__1_16": "簡短標籤名稱的使用規則",
    "guide_preset_editor__1_17": "當預設名稱過長時會使用簡短標籤名稱，僅影響按鈕上的顯示。",
    "guide_preset_editor__1_18": "群組顏色的顯示",
    "guide_preset_editor__1_19": "群組顏色會顯示於主工具中的「說明表格」中。",
    "guide_preset_editor__1_20": "我的最愛標記的顯示",
    "guide_preset_editor__1_21": "若設定了我的最愛（★），主工具中預設的右上角會顯示星號。",

    //▼2-3.メインツールの使い方（tagflot.html）
    "tagflot_feature_usage__1_1": "2-3. 主工具的使用方式（tagflot.html）",
    "tagflot_feature_usage__1_2": "基本使用方式",
    "tagflot_feature_usage__1_3": "標籤選擇",
    "tagflot_feature_usage__1_4": "點擊標籤或預設按鈕以選擇標籤。",
    "tagflot_feature_usage__1_5": "輸出設定",
    "tagflot_feature_usage__1_6": "在右下的輸出設定區域中設定格式、範圍等。",
    "tagflot_feature_usage__1_7": "複製標籤",
    "tagflot_feature_usage__1_8": "點擊複製按鈕即可將所選標籤複製至剪貼簿。<br>可貼上於標籤表格下方的文字區域查看內容。<br>下方的重設按鈕可清除貼上的內容。",
    "tagflot_feature_usage__1_9": "在 Eagle 中套用標籤",
    "tagflot_feature_usage__1_10": "貼到 Eagle 的「新增標籤」欄位中即可套用標籤。",
    "tagflot_feature_usage__1_11": "各功能的要點",
    "tagflot_feature_usage__1_12": "📦 關於預設",
    "tagflot_feature_usage__1_13": "選擇預設",
    "tagflot_feature_usage__1_14": "點擊預設按鈕會將其標籤加入當前選取項目。<br>已選擇的標籤不會重複。",
    "tagflot_feature_usage__1_15": "切換預設面板顯示",
    "tagflot_feature_usage__1_16": "可透過畫面右上的按鈕切換預設區塊的顯示。",
    "tagflot_feature_usage__1_17": "展開／收合所有群組與類別",
    "tagflot_feature_usage__1_18": "透過 OPEN／CLOSE 按鈕可一次展開或收合所有群組與類別。",
    "tagflot_feature_usage__1_19": "顯示我的最愛預設（★）",
    "tagflot_feature_usage__1_20": "標記為我的最愛的預設，按鈕右上會顯示 ★ 標記。<br>可於預設編輯工具中設定我的最愛。",
    "tagflot_feature_usage__1_21": "查看預設內容",
    "tagflot_feature_usage__1_22": "將滑鼠懸停於預設上時，該預設所含標籤會於畫面中央以彈出方式顯示。",
    "tagflot_feature_usage__1_23": "⚙️ 輸出選項切換",
    "tagflot_feature_usage__1_24": "輸出與操作設定",
    "tagflot_feature_usage__1_25": "您可以從以下三種格式中選擇輸出：<br>・類別標籤：標籤標籤<br>・類別ID：標籤標籤<br>・僅標籤標籤<br>※即使設定了短標籤，也會輸出標籤的標籤名稱。",
    "tagflot_feature_usage__1_26": "選擇輸出對象",
    "tagflot_feature_usage__1_27": "可選擇僅輸出「已展開的類別」或「所有類別」。<br>也可設定是否包含未選取的標籤。",
    "tagflot_feature_usage__1_28": "以氣泡顯示說明",
    "tagflot_feature_usage__1_29": "滑鼠懸停時會顯示該標籤／類別的說明氣泡。<br>此功能可於設定中開啟或關閉。",
    "tagflot_feature_usage__1_30": "點擊音效設定",
    "tagflot_feature_usage__1_31": "可設定點擊按鈕時是否播放音效。<br>此設定會自動儲存在瀏覽器中。",
    "tagflot_feature_usage__1_32": "儲存輸出設定",
    "tagflot_feature_usage__1_33": "輸出格式、範圍、氣泡說明與音效設定會自動儲存在瀏覽器中。<br>也提供設定重設按鈕。",
    "tagflot_feature_usage__1_34": "📖 關於按鈕列表",
    "tagflot_feature_usage__1_35": "按鈕列表欄的開關",
    "tagflot_feature_usage__1_36": "可使用畫面左上方的按鈕切換按鈕列表欄的顯示或隱藏。",
    "tagflot_feature_usage__1_37": "按鈕列表",
    "tagflot_feature_usage__1_38": "各按鈕的標籤與內容會以表格形式顯示。",
    "tagflot_feature_usage__1_39": "展開／收合所有群組與類別",
    "tagflot_feature_usage__1_40": "使用 OPEN／CLOSE 按鈕可一次開關所有群組與類別。",
    "tagflot_feature_usage__1_41": "🏷️ 關於標籤選擇",
    "tagflot_feature_usage__1_42": "標籤選擇顯示",
    "tagflot_feature_usage__1_43": "選擇的標籤會顯示在畫面底部。點擊可跳至對應類別。<br>將游標移至標籤上時，右上會出現 × 按鈕以單獨取消選擇。",
    "tagflot_feature_usage__1_44": "關於「未選擇」按鈕",
    "tagflot_feature_usage__1_45": "預設情況下，各類別中會選取「未選擇」按鈕。<br>選取標籤後再點擊此按鈕可清除該類別中的所有選擇。",
    "tagflot_feature_usage__1_46": "📝 關於程式碼產生區",
    "tagflot_feature_usage__1_47": "點擊標籤表下方的「＋」按鈕可開啟程式碼產生區。<br>可進行直接編輯程式碼的產出或標籤／預設清單的輸出。<br>詳細使用方式與注意事項請見第 3 節。",

    //▼2-4.TSV/JS変換ツールの使い方
    "converter_feature_usage__1_1": "2-4.TSV/JS 轉換工具的使用說明（tool_convert_tsv_to_js.html）",
    "converter_feature_usage__1_2": "基本使用方式",
    "converter_feature_usage__1_3": "概要說明",
    "converter_feature_usage__1_4": "本工具可將以TSV格式編輯的標籤與預設資料，轉換為內部使用的 tags.js / presets.js 格式，方便從 Excel 或 Google 試算表匯入大量資料。",
    "converter_feature_usage__1_5": "主要用途",
    "converter_feature_usage__1_6": "・需要大量建立標籤或預設時・從多人協作的試算表導入資料時・想一次產生結構類似的預設時",
    "converter_feature_usage__1_7": "使用方法",
    "converter_feature_usage__1_8": "1. 從主工具匯出TSV格式的標籤／預設資料，貼到 Excel 或試算表中編輯，也可下載CSV用文字編輯器編輯。2. 編輯後的資料可透過讀取CSV檔或貼上欄位資料來匯入。3. 按下「轉換」按鈕，即會生成整形後的程式碼，可貼到 tags.js 或 presets.js 中。",
    "converter_feature_usage__1_9": "輸入與輸出格式",
    "converter_feature_usage__1_10": "輸入資料須知",
    "converter_feature_usage__1_11": "標籤名稱與 ID 為必填。ID 必須使用以下接頭詞之一：preset-gp__、tagu-gp__、preset__、tag__，或所屬分類 ID + __。ID 僅能使用半形英數與底線（_），且不得包含連續底線或底線開頭／結尾。",
    "converter_feature_usage__1_12": "錯誤提示",
    "converter_feature_usage__1_13": "若輸入資料有誤，通知區會顯示警告，且不會產生輸出。",
    "converter_feature_usage__1_14": "輸出資料處理",
    "converter_feature_usage__1_15": "產出的程式碼可直接貼入 tags.js 或 presets.js，也可複製到剪貼簿或透過儲存按鈕下載。",
    "converter_feature_usage__1_16": "小技巧",
    "converter_feature_usage__1_17": "TSV 會輸出完整 ID（包含接頭詞），但編輯工具則使用簡化 ID（去除接頭詞）。若需調整結構（如新增群組、變更分類），建議使用編輯工具。",

    //▼2-5.アップデート通知機能について
    "guide_update_notify__1_1": "2-5. 關於更新通知功能",
    "guide_update_notify__1_2": "關於更新通知功能",
    "guide_update_notify__1_3": "可隨時點擊主工具右下角的<strong>更新通知按鈕</strong>查看最新資訊與公告。<br>（需連接網路／不會傳送任何資料）",
    "guide_update_notify__1_4": "🔃 更新時的資料延續方法",
    "guide_update_notify__1_5": "要導入新版 tagflot，只需將舊版 <code>data</code> 資料夾內的檔案（如 tags.js、presets.js）複製並覆蓋到新版的 <code>data</code> 資料夾中，即可延續使用現有資料。<br>※ 未來若有格式變更，也會提供專用轉換工具。",

    //▼3-1.コード生成の使い方
    "guide_section_codegen__1_1": "3-1. 程式碼產生的使用方式",
    "guide_section_codegen__1_2": "如何使用程式碼產生功能",
    "guide_section_codegen__1_3": "在<strong>程式碼產生區</strong>中，可以產出各種標籤、預設、群組、類別的程式碼，並<strong>輸出目前使用的標籤與預設清單（Tab 分隔或 CSV 格式）</strong>。<br>※標籤與預設的新增與編輯可透過 GUI 完成，但也可視需要使用手動產生程式碼與資料輸出功能。<br><strong>類別開關按鈕的建立方法</strong>另有專屬章節說明。",
    "guide_section_codegen__1_4": "📤 輸出標籤／預設清單的步驟",
    "guide_section_codegen__1_5": "1. 從主工具匯出目前使用中的標籤／預設清單。",
    "guide_section_codegen__1_6": "2. 將輸出內容複製後貼上至 Excel 等，或另存為 CSV 進行編輯。",
    "guide_section_codegen__1_7": "3. 將編輯後的內容貼到<strong>轉換工具</strong>中轉換。",
    "guide_section_codegen__1_8": "4. 將產生的 <code>tags.js</code> 或 <code>presets.js</code> <strong>覆蓋至 data 資料夾</strong>，或貼到既有檔案中儲存。",
    "guide_section_codegen__1_9": "⚠️ 注意事項",
    "guide_section_codegen__1_10": "此輸出為<strong>輔助功能，用於列出目前使用中的資料</strong>。",
    "guide_section_codegen__1_11": "變更標籤名稱或結構不會自動反映，修改後請重新輸出並再次轉換。",

    //▼3-2カテゴリ操作ボタンの使い方・追加方法
    "guide_section_category_toggle__1_1": "3-2. 類別操作按鈕的使用與新增方式",
    "guide_section_category_toggle__1_2": "如何使用類別操作按鈕",
    "guide_section_category_toggle__1_3": "🗂️ 什麼是類別操作按鈕？",
    "guide_section_category_toggle__1_4": "「類別操作按鈕」是一種可一次展開／收合或重新排序多個類別的功能。<br>分為「標準按鈕」與「自訂類別開關按鈕」。",
    "guide_section_category_toggle__1_5": "🔘 各標準按鈕的規格",
    "guide_section_category_toggle__1_6": "※ 按鈕名稱與說明可能因語言設定而略有不同。",
    "guide_section_category_toggle__1_7": "自訂類別開關按鈕",
    "guide_section_category_toggle__1_8": "⭐ 什麼是自訂類別開關按鈕？",
    "guide_section_category_toggle__1_9": "「自訂類別開關按鈕」可讓您<strong>一鍵控制多個類別的開／關狀態</strong>。<br>適合常用多組類別或依場景切換顯示時使用。",
    "guide_section_category_toggle__1_10": "🛠️ 建立方式",
    "guide_section_category_toggle__1_11": "1. 僅將想要開啟的類別設為「開啟狀態」<br>2. 在主工具的程式碼產生表單中輸入「名稱」與「ID」（如：open_char）<br>3. 點選「產生類別開關按鈕」產出程式碼<br>4. 將程式碼貼到 button_toggle_category.js 並儲存即完成註冊",
    "guide_section_category_toggle__1_12": "⚠️ 注意事項",
    "guide_section_category_toggle__1_13": "ID 會自動加上前綴。<br>請勿修改。<br>（例：tagCategoryToggle__open_char）<br>以下是單一按鈕的定義範例。",
    "guide_section_category_toggle__1_14": "🔢 自訂群組結構範例",
    "guide_section_category_toggle__1_15": "群組間請使用逗號 <code>,</code> 分隔，可自由新增或調整順序。<br>如不需要，亦可刪除標準群組（如 openAll、closeAll）。",

    //▼3-3.特殊タグの使い方・追加方法
    "guide_section_special_tags__1_1": "3-3. 特殊標籤的使用與新增方式",
    "guide_section_special_tags__1_2": "關於特殊標籤",
    "guide_section_special_tags__1_3": "🔖 什麼是特殊標籤？",
    "guide_section_special_tags__1_4": "特殊標籤可在所有類別中共用。<br><strong>標準特殊標籤</strong>（如「未選擇」「不適用」「其他」）可於所有類別中使用，<br>可切換顯示／隱藏，但<strong>名稱、說明與 ID 不可變更</strong>。<br>「未選擇」標籤無法隱藏。",
    "guide_section_special_tags__1_5": "自訂特殊標籤",
    "guide_section_special_tags__1_6": "⭐ 什麼是自訂特殊標籤？",
    "guide_section_special_tags__1_7": "可自行建立可顯示於多個類別的特殊標籤。<br>每個類別中的顯示與否可在標籤編輯工具中設定，與標準標籤相同。",
    "guide_section_special_tags__1_8": "🛠️ 新增自訂特殊標籤的方法",
    "guide_section_special_tags__1_9-1": "請複製 /data/special_tag_settings.js 中的標準標籤作為範本。",
    "guide_section_special_tags__1_9-2": "<strong>idSuffix</strong> 為標籤 ID，僅可使用半形英數與底線。格式為 <code>special_tag__A</code>。A 部分不可以下劃線開頭或結尾，亦不可有連續底線（__）。請避免與其他特殊標籤重複。",
    "guide_section_special_tags__1_9-3": "請輸入 <strong>defaultLabel</strong>（必填標籤名稱），<strong>description</strong> 可選填說明或備註。",
    "guide_section_special_tags__1_10": "範例（1 個自訂標籤）：",
    "guide_section_special_tags__1_11": "🔢 special_tag_settings.js 完整範例",
    "guide_section_special_tags__1_12": "※ 3 種標準標籤（未選擇、不適用、其他）不可修改。<br>請依相同格式新增自訂特殊標籤。<br>新增時請注意逗號使用。",

    //▼3-4.効果的な使い方・活用術
    "guide_section_tips__1_1": "3-4. 有效用法與活用技巧",
    "guide_section_tips__1_2": "有效用法與活用技巧",
    "guide_section_tips__1_3": "🗂️ 依類型切換類別顯示",
    "guide_section_tips__1_4": "為每種影片類型使用「自訂開關按鈕」預先設定所需的類別。<br>輸出時選擇「僅限展開的類別」，可依類型有效管理所需標籤。",
    "guide_section_tips__1_5": "➖ 善用「未選擇」標籤",
    "guide_section_tips__1_6": "將「未選擇標籤」一併輸出，可以明確區分：<br>－這個標籤是「刻意不加」<br>－還是「尚未判斷」<br>這樣能提升資料的可靠性。",
    "guide_section_tips__1_7": "📦 透過預設進行大量選擇",
    "guide_section_tips__1_8": "利用預設功能可一鍵選擇常用標籤組合，<br>大幅提升影片記錄與分類作業的效率。",
    "guide_section_tips__1_9": "💡 善用 Eagle 的智慧型資料夾",
    "guide_section_tips__1_10": "將標籤或預設的分類資料與 Eagle 的智慧型資料夾搭配使用，<br>即可迅速篩選出所需素材或影片。",

    //▼3-5.効果的な使い方・活用術
    "guide_section_faq__1_1": "3-5.補充與素材說明",
    "guide_section_faq__1_2": "關於圖示",
    "guide_section_faq__1_3": "配發套件中包含圖示檔案（Windows用ICO、Mac用ICNS）存放於 <code>docs/image/</code> 資料夾。<br>若您想使用本工具的圖示，請使用這些圖片。",

    //▼3-6.Eagle側のカテゴリ名・区切りの変換について
    "guide_related_tools__1_1": "3-6.Eagle 側的類別名稱與分隔符轉換",
    "guide_related_tools__1_2": "Eagle Tag Converter",
    "guide_related_tools__1_3": "概要",
    "guide_related_tools__1_4": "此桌面應用程式可將 Eagle 中的現有標籤批次轉換，<br>以符合 tagflot 的輸出格式（無類別名稱 / ： / _ / __）。",
    "guide_related_tools__1_5": "主要功能",
    "guide_related_tools__1_6": "・類別名稱與標籤之間的分隔符批次轉換<br>・類別名稱批次更名<br><strong>具備備份／還原功能，通常使用下可安全轉換。</strong><br>※本工具為非官方工具，使用請自行承擔風險。",
    "guide_related_tools__1_7": "詳細與下載",
    "guide_related_tools__1_8": "詳細說明與最新下載，請參考 tagflot 的發佈頁面。<br>▶︎ <a href=\"https://flotidot.com/tools/tagflot/index.html\" target=\"_blank\">Eagle Tag Converter（tagflot 發佈頁面）</a>",
    //▼4-1.このツールを作った理由
    "guide_section_motivation__1_1": "4-1. 製作本工具的理由",
    "guide_section_motivation__1_2": "製作本工具的理由",
    "guide_section_motivation__1_3": "「想整理參考資料，卻不擅長分類與標籤，總是停滯不前」<br>這樣的自身煩惱促使我製作了本工具。",
    "guide_section_motivation__1_4": "即使收集了參考影片，回頭看時還是沒有被好好分類。<br>我意識到問題出在「分類系統」而非素材本身，<br>因此想打造一款更直覺、適合自己的工具。",
    "guide_section_motivation__1_5": "UI、顯示順序與輸出格式，全都根據實際使用時的操作流程設計。<br>雖然是自用工具，但若能幫助他人整理資料我也會很高興。",
    "guide_section_motivation__1_5b": "其實大部分都是出於興趣和玩心，功能也不小心做太多了。<br>本來根本沒必要做到這麼全面（笑），既然如此，也希望能對其他人有幫助。",
    "guide_section_motivation__1_6": "最後，衷心感謝 Eagle 的開發團隊帶來這麼棒的工具。",
    "guide_section_motivation__1_7": "2025年7月15日<br><strong>Avery</strong>",

    //▼4-2.多言語対応について
    "guide_section_language__1_1": "4-2. 關於多語系支援",
    "guide_section_language__1_2": "關於多語系支援",
    "guide_section_language__1_3": "可透過畫面右上的語言選擇器切換日文、英文與繁體中文。<br>翻譯內容由 AI 與人工共同處理，若出現表述或品質差異，敬請見諒。<br>由於 Eagle 為台灣開發軟體，因此特別支援繁體中文。<br>其他語言未來可能隨機新增或移除。",
    "guide_section_language__1_4": "⚠️ 切換語言時的注意事項",
    "guide_section_language__1_5": "切換下拉選單中的語言後，若部分畫面未即時更新，請重新載入頁面以正確套用變更。",

    //▼4-3.バージョン情報
    "guide_section_version": "4-3. 版本資訊",
    "guide_version_note": "※ 本段內容僅提供日文版本",

    //▼4-4.ライセンス・利用条件・コンタクト
    "guide_section_license__1_1": "4-4. 授權條款 / 使用條件 / 聯絡方式",
    "guide_section_license__1_2": "授權條款・使用條件・聯絡方式",
    "guide_section_license__1_3": "本工具與指南的版權歸開發者（Avery）所有。",
    "guide_section_license__1_4": "允許個人使用與自訂，但",
    "guide_section_license__1_5": "再發布",
    "guide_section_license__1_6": "是不允許的。",
    "guide_section_license__1_11": "聯絡方式",
    "guide_section_license__1_12": "如有反饋、問題、感想或聯絡，",
    "guide_section_license__1_contact": "如有意見、問題或聯絡需求，可透過下方的官方網站表單或 X（前稱 Twitter）與我們聯繫。<br>SNS 連結可於官方網站與下載頁面中找到。",

    //フッター
    "guide_footer__1_1": "官方下載頁面：",
    "guide_footer__1_2": "最新更新資訊請參見此頁。",
  },
};
